/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.search.bytes;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import net.amygdalum.stringsearchalgorithms.io.ByteProvider;
import net.amygdalum.stringsearchalgorithms.search.AbstractStringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinderOption;
import net.amygdalum.stringsearchalgorithms.search.StringMatch;
import net.amygdalum.stringsearchalgorithms.search.bytes.MultiStringSearchAlgorithmFactory;
import net.amygdalum.stringsearchalgorithms.search.bytes.StringSearchAlgorithm;
import net.amygdalum.stringsearchalgorithms.search.bytes.TrieNode;
import net.amygdalum.util.map.ByteObjectMap;
import net.amygdalum.util.text.ByteString;
import net.amygdalum.util.text.ByteUtils;
import net.amygdalum.util.text.StringUtils;

public class SetBackwardOracleMatching
implements StringSearchAlgorithm {
    private TrieNode<List<byte[]>> trie;
    private int minLength;

    public SetBackwardOracleMatching(Collection<String> patterns, Charset charset) {
        List<byte[]> bytepatterns = StringUtils.toByteArray(patterns, charset);
        this.minLength = ByteUtils.minLength(bytepatterns);
        this.trie = SetBackwardOracleMatching.computeTrie(bytepatterns, this.minLength);
    }

    private static TrieNode<List<byte[]>> computeTrie(List<byte[]> bytepatterns, int length) {
        TrieNode<List<byte[]>> trie = new TrieNode<List<byte[]>>();
        for (byte[] pattern : bytepatterns) {
            byte[] prefix = Arrays.copyOfRange(pattern, 0, length);
            trie.extend(ByteUtils.revert(prefix), 0);
        }
        SetBackwardOracleMatching.computeOracle(trie);
        SetBackwardOracleMatching.computeTerminals(trie, bytepatterns, length);
        return trie;
    }

    private static void computeOracle(TrieNode<List<byte[]>> trie) {
        IdentityHashMap<TrieNode<List<byte[]>>, TrieNode<List<byte[]>>> oracle = new IdentityHashMap<TrieNode<List<byte[]>>, TrieNode<List<byte[]>>>();
        TrieNode<List<byte[]>> init = trie;
        oracle.put(init, null);
        LinkedList<TrieNode<List<byte[]>>> worklist = new LinkedList<TrieNode<List<byte[]>>>();
        worklist.add(trie);
        while (!worklist.isEmpty()) {
            TrieNode current = (TrieNode)worklist.remove();
            List<TrieNode<List<byte[]>>> nexts = SetBackwardOracleMatching.process(current, oracle, init);
            worklist.addAll(nexts);
        }
    }

    private static List<TrieNode<List<byte[]>>> process(TrieNode<List<byte[]>> parent, Map<TrieNode<List<byte[]>>, TrieNode<List<byte[]>>> oracle, TrieNode<List<byte[]>> init) {
        ArrayList<TrieNode<List<byte[]>>> nexts = new ArrayList<TrieNode<List<byte[]>>>();
        for (ByteObjectMap.Entry entry : parent.getNexts().cursor()) {
            byte c = entry.key;
            TrieNode trie = (TrieNode)entry.value;
            TrieNode<List<byte[]>> down = oracle.get(parent);
            while (down != null && down.nextNode(c) == null) {
                down.addNext(c, trie);
                down = oracle.get(down);
            }
            if (down != null) {
                TrieNode<List<byte[]>> next = down.nextNode(c);
                oracle.put(trie, next);
            } else {
                oracle.put(trie, init);
            }
            nexts.add(trie);
        }
        return nexts;
    }

    private static void computeTerminals(TrieNode<List<byte[]>> trie, List<byte[]> patterns, int minLength) {
        for (byte[] pattern : patterns) {
            byte[] prefix = Arrays.copyOfRange(pattern, 0, minLength);
            TrieNode<List<byte[]>> terminal = trie.nextNode(ByteUtils.revert(prefix));
            List<byte[]> terminalPatterns = terminal.getAttached();
            if (terminalPatterns == null) {
                terminalPatterns = new ArrayList<byte[]>();
                terminal.setAttached(terminalPatterns);
                terminalPatterns.add(prefix);
            }
            byte[] tail = Arrays.copyOfRange(pattern, minLength, pattern.length);
            terminalPatterns.add(tail);
        }
    }

    @Override
    public StringFinder createFinder(ByteProvider bytes, StringFinderOption ... options) {
        return new Finder(bytes, options);
    }

    @Override
    public int getPatternLength() {
        return this.minLength;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Factory
    implements MultiStringSearchAlgorithmFactory {
        private Charset charset;

        public Factory() {
            this(StandardCharsets.UTF_16LE);
        }

        public Factory(Charset charset) {
            this.charset = charset;
        }

        @Override
        public StringSearchAlgorithm of(Collection<String> patterns) {
            return new SetBackwardOracleMatching(patterns, this.charset);
        }
    }

    private class Finder
    extends AbstractStringFinder {
        private ByteProvider bytes;
        private Queue<StringMatch> buffer;

        public Finder(ByteProvider bytes, StringFinderOption ... options) {
            super(options);
            this.bytes = bytes;
            this.buffer = new LinkedList<StringMatch>();
        }

        @Override
        public void skipTo(long pos) {
            if (pos > this.bytes.current()) {
                this.bytes.move(pos);
            }
            this.buffer.clear();
        }

        @Override
        public StringMatch findNext() {
            if (!this.buffer.isEmpty()) {
                return this.buffer.remove();
            }
            int lookahead = SetBackwardOracleMatching.this.minLength - 1;
            while (!this.bytes.finished(lookahead)) {
                List patterns;
                Iterator iPatterns;
                byte[] prefix;
                int j;
                TrieNode current = SetBackwardOracleMatching.this.trie;
                for (j = lookahead; j >= 0 && current != null; current = current.nextNode(this.bytes.lookahead(j)), --j) {
                }
                long currentWindowStart = this.bytes.current();
                long currentPos = currentWindowStart + (long)j + 1L;
                long currentWindowEnd = currentWindowStart + (long)SetBackwardOracleMatching.this.minLength;
                byte[] matchedPrefix = this.bytes.between(currentPos, currentWindowEnd);
                if (current != null && j < 0 && Arrays.equals(prefix = (byte[])(iPatterns = (patterns = (List)current.getAttached()).iterator()).next(), matchedPrefix)) {
                    while (iPatterns.hasNext()) {
                        byte[] matchedSuffix;
                        byte[] suffix = (byte[])iPatterns.next();
                        long currentWordEnd = currentWindowEnd + (long)suffix.length;
                        if (this.bytes.finished((int)(currentWordEnd - currentWindowStart - 1L)) || !Arrays.equals(suffix, matchedSuffix = this.bytes.between(currentWindowEnd, currentWordEnd))) continue;
                        this.buffer.add(this.createMatch(currentWindowStart, currentWordEnd));
                    }
                    this.bytes.next();
                    if (this.buffer.isEmpty()) continue;
                    return this.buffer.remove();
                }
                if (j <= 0) {
                    this.bytes.next();
                    continue;
                }
                this.bytes.forward(j + 1);
            }
            return null;
        }

        private StringMatch createMatch(long start, long end) {
            ByteString s = this.bytes.slice(start, end);
            return new StringMatch(start, end, s.getString());
        }
    }
}

