/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.search;

import java.util.ArrayList;
import java.util.List;
import net.amygdalum.stringsearchalgorithms.search.MatchOption;
import net.amygdalum.stringsearchalgorithms.search.StringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinderOption;
import net.amygdalum.stringsearchalgorithms.search.StringMatch;

public abstract class AbstractStringFinder
implements StringFinder {
    private boolean nonOverlap;

    public AbstractStringFinder(StringFinderOption ... options) {
        this.nonOverlap = MatchOption.NON_OVERLAP.in(options);
    }

    @Override
    public abstract StringMatch findNext();

    @Override
    public abstract void skipTo(long var1);

    @Override
    public List<StringMatch> findAll() {
        ArrayList<StringMatch> matches = new ArrayList<StringMatch>();
        long last = -1L;
        StringMatch match;
        while ((match = this.findNext()) != null) {
            matches.add(match);
            if (!this.nonOverlap || match.end() <= last) continue;
            last = match.end();
            this.skipTo(last);
        }
        return matches;
    }
}

