/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.regex;

import java.util.ArrayList;
import java.util.List;
import net.amygdalum.stringsearchalgorithms.regex.CharNode;
import net.amygdalum.stringsearchalgorithms.regex.JoinableNode;
import net.amygdalum.stringsearchalgorithms.regex.RegexNode;
import net.amygdalum.stringsearchalgorithms.regex.RegexNodeVisitor;
import net.amygdalum.stringsearchalgorithms.regex.SingleCharNode;

public class StringNode
implements RegexNode,
JoinableNode {
    private String value;

    public StringNode(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public String getLiteralValue() {
        return this.value;
    }

    public List<CharNode> toCharNodes() {
        ArrayList<CharNode> charNodes = new ArrayList<CharNode>(this.value.length());
        for (char c : this.value.toCharArray()) {
            charNodes.add(new SingleCharNode(c));
        }
        return charNodes;
    }

    @Override
    public <T> T accept(RegexNodeVisitor<T> visitor) {
        return visitor.visitString(this);
    }

    @Override
    public StringNode clone() {
        try {
            return (StringNode)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String toString() {
        return this.value.toString();
    }
}

