/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.regex;

import java.util.Arrays;
import java.util.List;
import net.amygdalum.stringsearchalgorithms.regex.AbstractCharClassNode;
import net.amygdalum.stringsearchalgorithms.regex.DefinedCharNode;
import net.amygdalum.stringsearchalgorithms.regex.RegexNodeVisitor;

public class SpecialCharClassNode
extends AbstractCharClassNode {
    private char symbol;
    private List<DefinedCharNode> charNodes;

    public SpecialCharClassNode(char symbol, DefinedCharNode ... charNodes) {
        this(symbol, Arrays.asList(charNodes));
    }

    public SpecialCharClassNode(char symbol, List<DefinedCharNode> charNodes) {
        this.symbol = symbol;
        this.charNodes = charNodes;
    }

    public char getSymbol() {
        return this.symbol;
    }

    @Override
    public List<DefinedCharNode> toCharNodes() {
        return this.charNodes;
    }

    @Override
    public SpecialCharClassNode invert(char min, char max) {
        return new SpecialCharClassNode(Character.toUpperCase(this.symbol), SpecialCharClassNode.computeComplement(this.charNodes, min, max));
    }

    @Override
    public <T> T accept(RegexNodeVisitor<T> visitor) {
        return visitor.visitSpecialCharClass(this);
    }

    @Override
    public SpecialCharClassNode clone() {
        return (SpecialCharClassNode)super.clone();
    }

    public String toString() {
        return "\\" + this.symbol;
    }
}

