/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.regex;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.amygdalum.stringsearchalgorithms.regex.EmptyNode;
import net.amygdalum.stringsearchalgorithms.regex.JoinableNode;
import net.amygdalum.stringsearchalgorithms.regex.RegexNode;
import net.amygdalum.stringsearchalgorithms.regex.RegexNodeVisitor;
import net.amygdalum.stringsearchalgorithms.regex.StringNode;

public class ConcatNode
implements RegexNode {
    private List<RegexNode> subNodes;

    private ConcatNode(List<RegexNode> subNodes) {
        this.subNodes = subNodes;
    }

    public static ConcatNode inSequence(RegexNode ... nodes) {
        return ConcatNode.inSequence(Arrays.asList(nodes));
    }

    public static ConcatNode inSequence(List<? extends RegexNode> nodes) {
        LinkedList<RegexNode> subNodes = new LinkedList<RegexNode>();
        for (RegexNode regexNode : nodes) {
            if (regexNode instanceof ConcatNode) {
                subNodes.addAll(((ConcatNode)regexNode).getSubNodes());
                continue;
            }
            subNodes.add(regexNode);
        }
        return new ConcatNode(subNodes);
    }

    public RegexNode simplify() {
        List<RegexNode> newSubNodes = ConcatNode.joinIfPossible(this.subNodes);
        if (newSubNodes.isEmpty()) {
            return new EmptyNode();
        }
        if (newSubNodes.size() == 1) {
            return newSubNodes.get(0);
        }
        if (newSubNodes.equals(this.subNodes)) {
            return this;
        }
        return new ConcatNode(newSubNodes);
    }

    private static List<RegexNode> joinIfPossible(List<RegexNode> nodes) {
        LinkedList<RegexNode> joinedNodes = new LinkedList<RegexNode>();
        for (RegexNode node : nodes) {
            RegexNode last;
            RegexNode regexNode = last = joinedNodes.isEmpty() ? null : joinedNodes.getLast();
            if (last != null && last instanceof JoinableNode && node instanceof JoinableNode) {
                last = ConcatNode.joinChars((JoinableNode)last, (JoinableNode)node);
                joinedNodes.removeLast();
                joinedNodes.add(last);
                continue;
            }
            joinedNodes.add(node);
        }
        return joinedNodes;
    }

    private static StringNode joinChars(JoinableNode node1, JoinableNode node2) {
        return new StringNode(node1.getLiteralValue() + node2.getLiteralValue());
    }

    public List<RegexNode> getSubNodes() {
        return this.subNodes;
    }

    @Override
    public <T> T accept(RegexNodeVisitor<T> visitor) {
        return visitor.visitConcat(this);
    }

    @Override
    public ConcatNode clone() {
        try {
            ConcatNode clone = (ConcatNode)super.clone();
            clone.subNodes = new ArrayList<RegexNode>(this.subNodes.size());
            for (RegexNode subNode : this.subNodes) {
                clone.subNodes.add(subNode.clone());
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        Iterator<RegexNode> subNodeIterator = this.subNodes.iterator();
        while (subNodeIterator.hasNext()) {
            buffer.append(subNodeIterator.next());
        }
        return buffer.toString();
    }
}

