/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.regex;

import java.util.Arrays;
import java.util.List;
import net.amygdalum.stringsearchalgorithms.regex.AbstractCharClassNode;
import net.amygdalum.stringsearchalgorithms.regex.CompClassNode;
import net.amygdalum.stringsearchalgorithms.regex.DefinedCharNode;
import net.amygdalum.stringsearchalgorithms.regex.RegexNode;
import net.amygdalum.stringsearchalgorithms.regex.RegexNodeVisitor;

public class CharClassNode
extends AbstractCharClassNode
implements RegexNode {
    private List<DefinedCharNode> charNodes;

    public CharClassNode(DefinedCharNode ... charNodes) {
        this(Arrays.asList(charNodes));
    }

    public CharClassNode(List<DefinedCharNode> charNodes) {
        this.charNodes = charNodes;
    }

    @Override
    public List<DefinedCharNode> toCharNodes() {
        return this.charNodes;
    }

    @Override
    public CompClassNode invert(char min, char max) {
        return new CompClassNode(this.charNodes, CharClassNode.computeComplement(this.charNodes, min, max));
    }

    @Override
    public <T> T accept(RegexNodeVisitor<T> visitor) {
        return visitor.visitCharClass(this);
    }

    @Override
    public CharClassNode clone() {
        return (CharClassNode)super.clone();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('[');
        for (DefinedCharNode next : this.charNodes) {
            buffer.append(next.toInlinedString());
        }
        buffer.append(']');
        return buffer.toString();
    }
}

