/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.regex;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import net.amygdalum.stringsearchalgorithms.regex.AlternativesNode;
import net.amygdalum.stringsearchalgorithms.regex.AnyCharNode;
import net.amygdalum.stringsearchalgorithms.regex.BoundedLoopNode;
import net.amygdalum.stringsearchalgorithms.regex.CharClassNode;
import net.amygdalum.stringsearchalgorithms.regex.CompClassNode;
import net.amygdalum.stringsearchalgorithms.regex.ConcatNode;
import net.amygdalum.stringsearchalgorithms.regex.DefinedCharNode;
import net.amygdalum.stringsearchalgorithms.regex.EmptyNode;
import net.amygdalum.stringsearchalgorithms.regex.GroupNode;
import net.amygdalum.stringsearchalgorithms.regex.OptionalNode;
import net.amygdalum.stringsearchalgorithms.regex.RangeCharNode;
import net.amygdalum.stringsearchalgorithms.regex.RegexNode;
import net.amygdalum.stringsearchalgorithms.regex.RegexNodeVisitor;
import net.amygdalum.stringsearchalgorithms.regex.SingleCharNode;
import net.amygdalum.stringsearchalgorithms.regex.SpecialCharClassNode;
import net.amygdalum.stringsearchalgorithms.regex.StringNode;
import net.amygdalum.stringsearchalgorithms.regex.UnboundedLoopNode;

public class CharClassAnalyzer
implements RegexNodeVisitor<CharClassAnalyzer> {
    private SortedSet<DefinedCharNode> charClasses = new TreeSet<DefinedCharNode>();

    public SortedSet<DefinedCharNode> getCharClasses() {
        return this.charClasses;
    }

    @Override
    public CharClassAnalyzer visitAlternatives(AlternativesNode node) {
        return this.accept(node.getSubNodes());
    }

    @Override
    public CharClassAnalyzer visitAnyChar(AnyCharNode node) {
        return this.accept(node.toCharNodes());
    }

    @Override
    public CharClassAnalyzer visitCharClass(CharClassNode node) {
        return this.accept(node.toCharNodes());
    }

    @Override
    public CharClassAnalyzer visitCompClass(CompClassNode node) {
        return this.accept(node.toCharNodes());
    }

    @Override
    public CharClassAnalyzer visitConcat(ConcatNode node) {
        return this.accept(node.getSubNodes());
    }

    @Override
    public CharClassAnalyzer visitEmpty(EmptyNode node) {
        return this;
    }

    @Override
    public CharClassAnalyzer visitGroup(GroupNode node) {
        return node.getSubNode().accept(this);
    }

    @Override
    public CharClassAnalyzer visitBoundedLoop(BoundedLoopNode node) {
        return node.getSubNode().accept(this);
    }

    @Override
    public CharClassAnalyzer visitUnboundedLoop(UnboundedLoopNode node) {
        return node.getSubNode().accept(this);
    }

    @Override
    public CharClassAnalyzer visitOptional(OptionalNode node) {
        return node.getSubNode().accept(this);
    }

    @Override
    public CharClassAnalyzer visitRangeChar(RangeCharNode node) {
        return this.splitBy(node);
    }

    @Override
    public CharClassAnalyzer visitSingleChar(SingleCharNode node) {
        return this.splitBy(node);
    }

    private CharClassAnalyzer splitBy(DefinedCharNode node) {
        ArrayList<DefinedCharNode> splitNodes = new ArrayList<DefinedCharNode>();
        Iterator charClassIterator = this.charClasses.iterator();
        while (charClassIterator.hasNext()) {
            DefinedCharNode next = (DefinedCharNode)charClassIterator.next();
            if (!next.cuts(node)) continue;
            charClassIterator.remove();
            splitNodes.addAll(this.splitClasses(node, next));
        }
        if (splitNodes.isEmpty()) {
            this.charClasses.add(node);
        } else {
            this.charClasses.addAll(splitNodes);
        }
        return this;
    }

    private List<DefinedCharNode> splitClasses(DefinedCharNode node, DefinedCharNode next) {
        if (next.getFrom() < node.getFrom()) {
            DefinedCharNode temp = node;
            node = next;
            next = temp;
        }
        if (node.overlaps(next)) {
            return this.ranges(new RangeCharNode(node.getFrom(), (char)(next.getFrom() + '\u0001')), new RangeCharNode(next.getFrom(), node.getTo()), new RangeCharNode((char)(node.getTo() + '\u0001'), next.getTo()));
        }
        if (node.subsumes(next)) {
            return this.ranges(new RangeCharNode(node.getFrom(), (char)(next.getFrom() + '\u0001')), next, new RangeCharNode((char)(next.getTo() + '\u0001'), node.getTo()));
        }
        if (next.subsumes(node)) {
            return this.ranges(new RangeCharNode(next.getFrom(), (char)(node.getFrom() + '\u0001')), node, new RangeCharNode((char)(node.getTo() + '\u0001'), next.getTo()));
        }
        return Arrays.asList(node, next);
    }

    private List<DefinedCharNode> ranges(DefinedCharNode ... nodes) {
        ArrayList<DefinedCharNode> ranges = new ArrayList<DefinedCharNode>(nodes.length);
        for (DefinedCharNode node : nodes) {
            if (node instanceof RangeCharNode) {
                DefinedCharNode optimized = ((RangeCharNode)node).simplify();
                if (optimized == null) continue;
                ranges.add(optimized);
                continue;
            }
            ranges.add(node);
        }
        return ranges;
    }

    @Override
    public CharClassAnalyzer visitSpecialCharClass(SpecialCharClassNode node) {
        return this.accept(node.toCharNodes());
    }

    @Override
    public CharClassAnalyzer visitString(StringNode node) {
        return this.accept(node.toCharNodes());
    }

    private CharClassAnalyzer accept(List<? extends RegexNode> subNodes) {
        for (RegexNode regexNode : subNodes) {
            regexNode.accept(this);
        }
        return this;
    }
}

