/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.regex;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.amygdalum.stringsearchalgorithms.regex.EmptyNode;
import net.amygdalum.stringsearchalgorithms.regex.RegexNode;
import net.amygdalum.stringsearchalgorithms.regex.RegexNodeVisitor;

public class AlternativesNode
implements RegexNode {
    private List<RegexNode> subNodes;

    private AlternativesNode(List<RegexNode> subNodes) {
        this.subNodes = subNodes;
    }

    public static AlternativesNode anyOf(RegexNode ... nodes) {
        return AlternativesNode.anyOf(Arrays.asList(nodes));
    }

    public static AlternativesNode anyOf(List<? extends RegexNode> nodes) {
        LinkedList<RegexNode> subNodes = new LinkedList<RegexNode>();
        for (RegexNode regexNode : nodes) {
            if (regexNode instanceof AlternativesNode) {
                subNodes.addAll(((AlternativesNode)regexNode).getSubNodes());
                continue;
            }
            subNodes.add(regexNode);
        }
        return new AlternativesNode(subNodes);
    }

    public RegexNode simplify() {
        if (this.subNodes.isEmpty()) {
            return new EmptyNode();
        }
        if (this.subNodes.size() == 1) {
            return this.subNodes.get(0);
        }
        return this;
    }

    public List<RegexNode> getSubNodes() {
        return this.subNodes;
    }

    @Override
    public <T> T accept(RegexNodeVisitor<T> visitor) {
        return visitor.visitAlternatives(this);
    }

    @Override
    public AlternativesNode clone() {
        try {
            AlternativesNode clone = (AlternativesNode)super.clone();
            clone.subNodes = new ArrayList<RegexNode>(this.subNodes.size());
            for (RegexNode subNode : this.subNodes) {
                clone.subNodes.add(subNode.clone());
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        Iterator<RegexNode> subNodeIterator = this.subNodes.iterator();
        if (subNodeIterator.hasNext()) {
            buffer.append(subNodeIterator.next());
        }
        while (subNodeIterator.hasNext()) {
            buffer.append('|');
            buffer.append(subNodeIterator.next());
        }
        return buffer.toString();
    }
}

