/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.patternsearch.chars;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import net.amygdalum.stringsearchalgorithms.io.CharProvider;
import net.amygdalum.stringsearchalgorithms.patternsearch.chars.MatchListener;
import net.amygdalum.stringsearchalgorithms.search.StringMatch;

public class MatchBuilder
implements MatchListener {
    private boolean longest;
    private SortedSet<StringMatch> matches;

    public MatchBuilder(boolean longest) {
        this.longest = longest;
        this.matches = new TreeSet<StringMatch>();
    }

    @Override
    public void notify(long start, long end, CharProvider chars) {
        String s = chars.slice(start, end);
        this.matches.add(new StringMatch(start, end, s));
    }

    public SortedSet<StringMatch> getMatches() {
        if (this.longest && !this.matches.isEmpty()) {
            ArrayList<StringMatch> toRemove = new ArrayList<StringMatch>();
            Iterator matchIterator = this.matches.iterator();
            StringMatch longestMatch = (StringMatch)matchIterator.next();
            while (matchIterator.hasNext()) {
                StringMatch currentMatch = (StringMatch)matchIterator.next();
                if (currentMatch.start() > longestMatch.start()) {
                    longestMatch = currentMatch;
                    continue;
                }
                if (currentMatch.length() > longestMatch.length()) {
                    toRemove.add(longestMatch);
                    continue;
                }
                toRemove.add(currentMatch);
            }
            this.matches.removeAll(toRemove);
        }
        return this.matches;
    }
}

