/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.patternsearch.chars;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.amygdalum.stringsearchalgorithms.regex.AlternativesNode;
import net.amygdalum.stringsearchalgorithms.regex.AnyCharNode;
import net.amygdalum.stringsearchalgorithms.regex.BoundedLoopNode;
import net.amygdalum.stringsearchalgorithms.regex.CharClassNode;
import net.amygdalum.stringsearchalgorithms.regex.CompClassNode;
import net.amygdalum.stringsearchalgorithms.regex.ConcatNode;
import net.amygdalum.stringsearchalgorithms.regex.EmptyNode;
import net.amygdalum.stringsearchalgorithms.regex.GroupNode;
import net.amygdalum.stringsearchalgorithms.regex.OptionalNode;
import net.amygdalum.stringsearchalgorithms.regex.RangeCharNode;
import net.amygdalum.stringsearchalgorithms.regex.RegexNode;
import net.amygdalum.stringsearchalgorithms.regex.RegexNodeVisitor;
import net.amygdalum.stringsearchalgorithms.regex.SingleCharNode;
import net.amygdalum.stringsearchalgorithms.regex.SpecialCharClassNode;
import net.amygdalum.stringsearchalgorithms.regex.StringNode;
import net.amygdalum.stringsearchalgorithms.regex.UnboundedLoopNode;

public class BestFactorAnalyzer
implements RegexNodeVisitor<Factors> {
    private RegexNode root;
    private Factors factors;

    public BestFactorAnalyzer(RegexNode root) {
        this.root = root;
    }

    public Set<String> getBestFactors(Set<String> default1, Set<String> default2) {
        return BestFactorAnalyzer.bestOf(this.factors.prefix, this.factors.suffix, this.factors.factor, default1, default2);
    }

    public BestFactorAnalyzer analyze() {
        this.factors = this.root.accept(this);
        return this;
    }

    @SafeVarargs
    private static final Set<String> bestOf(Set<String> ... sets) {
        double maxScore = 0.0;
        Set<String> resultSet = null;
        for (Set<String> set : sets) {
            double score = BestFactorAnalyzer.score(set);
            if (score > maxScore) {
                resultSet = set;
                maxScore = score;
                continue;
            }
            if (score != maxScore || set.size() >= resultSet.size()) continue;
            resultSet = set;
        }
        return resultSet;
    }

    private static double score(Set<String> set) {
        if (set == null) {
            return -1.0;
        }
        double size = set.size();
        double sum = 0.0;
        for (String string : set) {
            sum += (double)string.length();
        }
        return sum / size;
    }

    @Override
    public Factors visitAlternatives(AlternativesNode node) {
        List<Factors> factors = this.accept(node.getSubNodes());
        return Factors.alternative(factors);
    }

    @Override
    public Factors visitAnyChar(AnyCharNode node) {
        List<Factors> factors = this.accept(node.toCharNodes());
        return Factors.alternative(factors);
    }

    @Override
    public Factors visitCharClass(CharClassNode node) {
        List<Factors> factors = this.accept(node.toCharNodes());
        return Factors.alternative(factors);
    }

    @Override
    public Factors visitCompClass(CompClassNode node) {
        List<Factors> factors = this.accept(node.toCharNodes());
        return Factors.alternative(factors);
    }

    @Override
    public Factors visitConcat(ConcatNode node) {
        List<Factors> factors = this.accept(node.getSubNodes());
        return Factors.concat(factors);
    }

    @Override
    public Factors visitEmpty(EmptyNode node) {
        return Factors.empty();
    }

    @Override
    public Factors visitGroup(GroupNode node) {
        return node.getSubNode().accept(this);
    }

    @Override
    public Factors visitBoundedLoop(BoundedLoopNode node) {
        Factors factor = node.getSubNode().accept(this);
        return Factors.variableSequence(factor, node.getFrom(), node.getTo());
    }

    @Override
    public Factors visitUnboundedLoop(UnboundedLoopNode node) {
        return Factors.invalid();
    }

    @Override
    public Factors visitOptional(OptionalNode node) {
        Factors factors = node.getSubNode().accept(this);
        return Factors.optional(factors);
    }

    @Override
    public Factors visitRangeChar(RangeCharNode node) {
        LinkedHashSet<String> factors = new LinkedHashSet<String>();
        for (char c = node.getFrom(); c <= node.getTo(); c = (char)(c + '\u0001')) {
            factors.add(String.valueOf(c));
        }
        return Factors.base(factors);
    }

    @Override
    public Factors visitSingleChar(SingleCharNode node) {
        return Factors.string(node.getLiteralValue());
    }

    @Override
    public Factors visitSpecialCharClass(SpecialCharClassNode node) {
        List<Factors> factors = this.accept(node.toCharNodes());
        return Factors.alternative(factors);
    }

    @Override
    public Factors visitString(StringNode node) {
        return Factors.string(node.getLiteralValue());
    }

    private List<Factors> accept(List<? extends RegexNode> subNodes) {
        ArrayList<Factors> factors = new ArrayList<Factors>(subNodes.size());
        for (RegexNode regexNode : subNodes) {
            factors.add(regexNode.accept(this));
        }
        return factors;
    }

    static class Factors {
        public Set<String> all;
        public Set<String> prefix;
        public Set<String> suffix;
        public Set<String> factor;

        public Factors(Set<String> all, Set<String> prefix, Set<String> suffix, Set<String> factor) {
            this.all = all;
            this.prefix = prefix;
            this.suffix = suffix;
            this.factor = factor;
        }

        public String toString() {
            return "{\nall    :" + this.all + "\nprefix :" + this.prefix + "\nsuffix :" + this.suffix + "\nfactor :" + this.factor + "\n}";
        }

        private static Set<String> concat(Set<String> prefixes, Set<String> suffixes) {
            if (prefixes == null || suffixes == null) {
                return null;
            }
            LinkedHashSet<String> concat = new LinkedHashSet<String>();
            for (String prefix : prefixes) {
                for (String suffix : suffixes) {
                    concat.add(prefix + suffix);
                }
            }
            return concat;
        }

        public static Factors alternative(List<Factors> factors) {
            Builder builder = new Builder();
            for (Factors factorsAlternative : factors) {
                builder.addAll(factorsAlternative.all);
                builder.addPrefix(factorsAlternative.prefix);
                builder.addSuffix(factorsAlternative.suffix);
                builder.addFactor(factorsAlternative.factor);
            }
            return builder.build();
        }

        public static Factors concat(List<Factors> factors) {
            Iterator<Factors> factorsIterator = factors.iterator();
            if (factorsIterator.hasNext()) {
                Factors factorsConcat = factorsIterator.next();
                Builder builder = new Builder(factorsConcat);
                while (factorsIterator.hasNext()) {
                    factorsConcat = factorsIterator.next();
                    Set<String> newPrefix = Factors.concat(builder.all, factorsConcat.prefix);
                    Set<String> newSuffix = Factors.concat(builder.suffix, factorsConcat.all);
                    Set<String> newFactor = Factors.concat(builder.prefix, factorsConcat.suffix);
                    builder.addAll(factorsConcat.all);
                    builder.updatePrefix(builder.prefix, newPrefix);
                    builder.updateSuffix(newSuffix, factorsConcat.suffix);
                    builder.updateFactor(builder.factor, factorsConcat.factor, newFactor);
                }
                return builder.build();
            }
            return Factors.empty();
        }

        public static Factors variableSequence(Factors factor, int from, int to) {
            int i;
            Factors result = factor;
            for (i = 0; i < from; ++i) {
                result = Factors.concat(Arrays.asList(result, factor));
            }
            for (i = from; i < to; ++i) {
                result = Factors.concat(Arrays.asList(result, Factors.alternative(Arrays.asList(factor, Factors.empty()))));
            }
            return result;
        }

        public static Factors optional(Factors factors) {
            return Factors.alternative(Arrays.asList(factors, Factors.empty()));
        }

        public static Factors base(Set<String> factors) {
            return new Factors(factors, factors, factors, factors);
        }

        public static Factors string(String factor) {
            HashSet<String> factors = new HashSet<String>();
            factors.add(factor);
            return Factors.base(factors);
        }

        public static Factors empty() {
            HashSet<String> empty = new HashSet<String>();
            empty.add("");
            return Factors.base(empty);
        }

        public static Factors invalid() {
            return Factors.base(null);
        }

        public static class Builder {
            private Set<String> all;
            private Set<String> prefix;
            private Set<String> suffix;
            private Set<String> factor;

            public Builder() {
                this.all = new LinkedHashSet<String>();
                this.prefix = new LinkedHashSet<String>();
                this.suffix = new LinkedHashSet<String>();
                this.factor = new LinkedHashSet<String>();
            }

            public Builder(Factors prototype) {
                this.all = prototype.all == null ? null : new LinkedHashSet<String>(prototype.all);
                this.prefix = prototype.prefix == null ? null : new LinkedHashSet<String>(prototype.prefix);
                this.suffix = prototype.suffix == null ? null : new LinkedHashSet<String>(prototype.suffix);
                this.factor = prototype.factor == null ? null : new LinkedHashSet<String>(prototype.factor);
            }

            public void addAll(Set<String> factors) {
                if (this.all == null) {
                    return;
                }
                if (factors == null) {
                    this.all = null;
                } else {
                    this.all.addAll(factors);
                }
            }

            public void addPrefix(Set<String> factors) {
                if (this.prefix == null) {
                    return;
                }
                if (factors == null) {
                    this.prefix = null;
                } else {
                    this.prefix.addAll(factors);
                }
            }

            @SafeVarargs
            public final void updatePrefix(Set<String> ... factors) {
                this.prefix = BestFactorAnalyzer.bestOf(factors);
            }

            public void addSuffix(Set<String> factors) {
                if (this.suffix == null) {
                    return;
                }
                if (factors == null) {
                    this.suffix = null;
                } else {
                    this.suffix.addAll(factors);
                }
            }

            @SafeVarargs
            public final void updateSuffix(Set<String> ... factors) {
                this.suffix = BestFactorAnalyzer.bestOf(factors);
            }

            public void addFactor(Set<String> factors) {
                if (this.factor == null) {
                    return;
                }
                if (factors == null) {
                    this.factor = null;
                } else {
                    this.factor.addAll(factors);
                }
            }

            @SafeVarargs
            public final void updateFactor(Set<String> ... factors) {
                this.factor = BestFactorAnalyzer.bestOf(factors);
            }

            public Factors build() {
                return new Factors(this.all, this.prefix, this.suffix, this.factor);
            }
        }
    }
}

