/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.io;

import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import net.amygdalum.stringsearchalgorithms.io.CharProvider;
import net.amygdalum.stringsearchalgorithms.io.IORuntimeException;
import net.amygdalum.stringsearchalgorithms.io.OutOfBufferException;

public class ReaderBufferCharProvider
implements CharProvider {
    private static final long NO_MARK = Long.MIN_VALUE;
    private Reader input;
    private int chunk;
    private int capacity;
    private CharBuffer buffer;
    private long absolutePos;
    private long mark;
    private int pos;
    private int state;

    public ReaderBufferCharProvider(Reader input, long start, int buffer, int reverseBuffers) {
        this.input = input;
        this.chunk = buffer;
        this.capacity = buffer * (reverseBuffers + 1);
        this.buffer = CharBuffer.allocate(this.capacity);
        this.mark = Long.MIN_VALUE;
        this.init(start);
    }

    public final void init(long start) {
        long shift = (start / (long)this.chunk + 1L) * (long)this.chunk;
        long skip = 0L;
        while (shift > (long)this.capacity) {
            shift -= (long)this.chunk;
            skip += (long)this.chunk;
        }
        if (skip > 0L) {
            this.skip(skip);
        }
        this.read();
        this.pos = (int)(start - skip);
        this.absolutePos = start;
    }

    public void read() {
        this.buffer.position(0);
        this.buffer.limit(this.capacity);
        try {
            this.state = this.input.read(this.buffer);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        this.buffer.flip();
    }

    public void shift(int shift) {
        this.buffer.position(shift);
        this.buffer.compact();
        try {
            this.state = this.input.read(this.buffer);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        this.buffer.flip();
        this.pos -= shift;
    }

    public void skip(long skip) {
        try {
            this.input.skip(skip);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    @Override
    public char next() {
        if (this.pos >= this.buffer.limit()) {
            this.shift(this.chunk);
        }
        char c = this.buffer.charAt(this.pos);
        ++this.pos;
        ++this.absolutePos;
        return c;
    }

    @Override
    public char lookahead() {
        return this.buffer.charAt(this.pos);
    }

    @Override
    public char lookahead(int i) {
        return this.buffer.charAt(this.pos + i);
    }

    @Override
    public char prev() {
        --this.pos;
        --this.absolutePos;
        if (this.pos < 0) {
            throw new OutOfBufferException();
        }
        return this.buffer.charAt(this.pos);
    }

    @Override
    public char lookbehind() {
        return this.buffer.charAt(this.pos - 1);
    }

    @Override
    public char lookbehind(int i) {
        return this.buffer.charAt(this.pos - 1 - i);
    }

    @Override
    public long current() {
        return this.absolutePos;
    }

    @Override
    public void move(long i) {
        long rel = i - this.absolutePos;
        if ((long)this.pos + rel < 0L) {
            int rev = this.pos + 1;
            this.pos = -1;
            this.absolutePos -= (long)rev;
            throw new OutOfBufferException();
        }
        int shift = 0;
        while ((long)(this.pos - shift) + rel > (long)this.buffer.limit()) {
            shift += this.chunk;
        }
        int skip = 0;
        while (shift > this.capacity) {
            shift -= this.chunk;
            skip += this.chunk;
        }
        if (skip > 0) {
            this.skip(skip);
        }
        this.shift(shift);
        this.pos = (int)((long)this.pos + rel);
        this.absolutePos += rel;
    }

    @Override
    public void forward(int i) {
        this.move(this.absolutePos + (long)i);
    }

    @Override
    public void finish() {
        try {
            this.pos = this.buffer.limit();
            this.state = -1;
            this.input.close();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    @Override
    public boolean finished() {
        if (this.buffer.limit() - this.pos > 0) {
            return false;
        }
        if (this.buffer.limit() - this.pos == 0 && this.state == -1) {
            return true;
        }
        this.shift(this.chunk);
        return this.buffer.limit() - this.pos <= 0 && this.state == -1;
    }

    @Override
    public boolean finished(int i) {
        if (this.buffer.limit() - this.pos > i) {
            return false;
        }
        if (this.buffer.limit() - this.pos <= i && this.state == -1) {
            return true;
        }
        if (this.pos % this.chunk + i >= this.capacity) {
            throw new OutOfBufferException();
        }
        int shift = 0;
        while (this.pos - shift + i >= this.capacity) {
            shift += this.chunk;
        }
        if (shift > 0 || this.buffer.limit() < this.capacity) {
            this.shift(shift);
        }
        return this.buffer.limit() - this.pos <= i && this.state == -1;
    }

    @Override
    public char at(long i) {
        long rel = i - this.absolutePos;
        if ((long)this.pos + rel < 0L) {
            int rev = this.pos + 1;
            this.pos = -1;
            this.absolutePos -= (long)rev;
            throw new OutOfBufferException();
        }
        if ((long)(this.pos % this.chunk) + rel >= (long)this.capacity) {
            throw new OutOfBufferException();
        }
        int shift = 0;
        while ((long)(this.pos - shift) + rel >= (long)this.capacity) {
            shift += this.chunk;
        }
        if (shift > 0 || this.buffer.limit() < this.capacity) {
            this.shift(shift);
        }
        return this.buffer.charAt((int)((long)this.pos + rel));
    }

    @Override
    public char[] between(long start, long end) {
        if (end - start + start % (long)this.chunk > (long)this.capacity) {
            throw new OutOfBufferException();
        }
        long startRel = start - this.absolutePos;
        long endRel = end - this.absolutePos;
        if ((long)this.pos + startRel < 0L) {
            int rev = this.pos + 1;
            this.pos = -1;
            this.absolutePos -= (long)rev;
            throw new OutOfBufferException();
        }
        int shift = 0;
        while ((long)(this.pos - shift) + endRel >= (long)this.buffer.limit()) {
            shift += this.chunk;
        }
        if (shift > this.pos) {
            throw new OutOfBufferException();
        }
        if (shift > 0 || this.buffer.limit() < this.capacity) {
            this.shift(shift);
        }
        int startSeq = (int)((long)this.pos + startRel);
        int endSeq = (int)((long)this.pos + endRel);
        char[] cs = new char[endSeq - startSeq];
        this.buffer.subSequence(startSeq, endSeq).get(cs);
        return cs;
    }

    @Override
    public String slice(long start, long end) {
        return new String(this.between(start, end));
    }

    @Override
    public void mark() {
        this.mark = this.absolutePos;
    }

    @Override
    public boolean changed() {
        boolean changed = this.mark != Long.MIN_VALUE && this.mark != this.absolutePos;
        this.mark = Long.MIN_VALUE;
        return changed;
    }

    public String toString() {
        return "..." + this.buffer.subSequence(0, this.pos) + '|' + this.buffer.subSequence(this.pos, this.buffer.limit());
    }
}

