/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.search.chars;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.amygdalum.stringsearchalgorithms.io.CharProvider;
import net.amygdalum.stringsearchalgorithms.search.AbstractStringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinderOption;
import net.amygdalum.stringsearchalgorithms.search.StringMatch;
import net.amygdalum.stringsearchalgorithms.search.chars.StringSearchAlgorithm;
import net.amygdalum.stringsearchalgorithms.search.chars.StringSearchAlgorithmFactory;
import net.amygdalum.stringsearchalgorithms.search.chars.SupportsCharClasses;
import net.amygdalum.stringsearchalgorithms.search.chars.TrieNode;
import net.amygdalum.util.map.CharObjectMap;
import net.amygdalum.util.text.CharMapping;
import net.amygdalum.util.text.CharUtils;

public class BOM
implements StringSearchAlgorithm {
    private TrieNode<char[]> trie;
    private int patternLength;

    public BOM(String pattern) {
        this(pattern, CharMapping.IDENTITY);
    }

    public BOM(String pattern, CharMapping mapping) {
        this.patternLength = pattern.length();
        this.trie = BOM.computeTrie(mapping.normalized(pattern.toCharArray()), this.patternLength);
        if (mapping != CharMapping.IDENTITY) {
            this.applyMapping(mapping);
        }
    }

    private void applyMapping(CharMapping mapping) {
        Set<TrieNode<char[]>> nodes = this.trie.nodes();
        for (TrieNode<char[]> node : nodes) {
            this.applyMapping(node, mapping);
        }
    }

    private void applyMapping(TrieNode<char[]> node, CharMapping mapping) {
        CharObjectMap<TrieNode<char[]>> nexts = node.getNexts();
        node.reset();
        for (CharObjectMap.Entry entry : nexts.cursor()) {
            char ec = entry.key;
            TrieNode next = (TrieNode)entry.value;
            for (char c : mapping.map(ec)) {
                node.addNext(c, next);
            }
        }
    }

    private static TrieNode<char[]> computeTrie(char[] pattern, int length) {
        TrieNode<char[]> trie = new TrieNode<char[]>();
        TrieNode<char[]> node = trie.extend(CharUtils.revert(pattern), 0);
        node.setAttached(pattern);
        BOM.computeOracle(trie);
        return trie;
    }

    private static void computeOracle(TrieNode<char[]> trie) {
        IdentityHashMap<TrieNode<char[]>, TrieNode<char[]>> oracle = new IdentityHashMap<TrieNode<char[]>, TrieNode<char[]>>();
        TrieNode<char[]> init = trie;
        oracle.put(init, null);
        LinkedList<TrieNode<char[]>> worklist = new LinkedList<TrieNode<char[]>>();
        worklist.add(trie);
        while (!worklist.isEmpty()) {
            TrieNode current = (TrieNode)worklist.remove();
            List<TrieNode<char[]>> nexts = BOM.process(current, oracle, init);
            worklist.addAll(nexts);
        }
    }

    private static List<TrieNode<char[]>> process(TrieNode<char[]> parent, Map<TrieNode<char[]>, TrieNode<char[]>> oracle, TrieNode<char[]> init) {
        ArrayList<TrieNode<char[]>> nexts = new ArrayList<TrieNode<char[]>>();
        for (CharObjectMap.Entry entry : parent.getNexts().cursor()) {
            char c = entry.key;
            TrieNode trie = (TrieNode)entry.value;
            TrieNode<char[]> down = oracle.get(parent);
            while (down != null && down.nextNode(c) == null) {
                down.addNext(c, trie);
                down = oracle.get(down);
            }
            if (down != null) {
                TrieNode<char[]> next = down.nextNode(c);
                oracle.put(trie, next);
            } else {
                oracle.put(trie, init);
            }
            nexts.add(trie);
        }
        return nexts;
    }

    @Override
    public int getPatternLength() {
        return this.patternLength;
    }

    @Override
    public StringFinder createFinder(CharProvider chars, StringFinderOption ... options) {
        return new Finder(chars, options);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Factory
    implements StringSearchAlgorithmFactory,
    SupportsCharClasses {
        private CharMapping mapping;

        @Override
        public void enableCharClasses(CharMapping mapping) {
            this.mapping = mapping;
        }

        @Override
        public StringSearchAlgorithm of(String pattern) {
            if (this.mapping == null) {
                return new BOM(pattern);
            }
            return new BOM(pattern, this.mapping);
        }
    }

    private class Finder
    extends AbstractStringFinder {
        private CharProvider chars;

        public Finder(CharProvider chars, StringFinderOption ... options) {
            super(options);
            this.chars = chars;
        }

        @Override
        public void skipTo(long pos) {
            if (pos > this.chars.current()) {
                this.chars.move(pos);
            }
        }

        @Override
        public StringMatch findNext() {
            int lookahead = BOM.this.patternLength - 1;
            while (!this.chars.finished(lookahead)) {
                int j;
                TrieNode current = BOM.this.trie;
                for (j = lookahead; j >= 0 && current != null; current = current.nextNode(this.chars.lookahead(j)), --j) {
                }
                if (current != null && j < 0) {
                    char[] pattern = (char[])current.getAttached();
                    long start = this.chars.current();
                    long end = start + (long)pattern.length;
                    StringMatch match = this.createMatch(start, end);
                    this.chars.next();
                    return match;
                }
                if (j <= 0) {
                    this.chars.next();
                    continue;
                }
                this.chars.forward(j + 2);
            }
            return null;
        }

        private StringMatch createMatch(long start, long end) {
            String s = this.chars.slice(start, end);
            return new StringMatch(start, end, s);
        }
    }
}

