/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.search.bytes;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import net.amygdalum.stringsearchalgorithms.io.ByteProvider;
import net.amygdalum.stringsearchalgorithms.search.AbstractStringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinderOption;
import net.amygdalum.stringsearchalgorithms.search.StringMatch;
import net.amygdalum.stringsearchalgorithms.search.bytes.BitMapStates;
import net.amygdalum.stringsearchalgorithms.search.bytes.Encoding;
import net.amygdalum.stringsearchalgorithms.search.bytes.StringSearchAlgorithm;
import net.amygdalum.stringsearchalgorithms.search.bytes.StringSearchAlgorithmFactory;
import net.amygdalum.util.text.ByteString;

public class BNDM
implements StringSearchAlgorithm {
    private int patternLength;
    private BitMapStates states;

    public BNDM(String pattern, Charset charset) {
        byte[] encoded = Encoding.encode(pattern, charset);
        this.patternLength = encoded.length;
        this.states = BNDM.computeStates(encoded);
    }

    private static BitMapStates computeStates(byte[] pattern) {
        if (pattern.length > 64) {
            return new QuickMultiLongStates(pattern);
        }
        return new QuickSingleLongStates(pattern);
    }

    @Override
    public int getPatternLength() {
        return this.patternLength;
    }

    @Override
    public StringFinder createFinder(ByteProvider bytes, StringFinderOption ... options) {
        if (this.states.supportsSingle()) {
            return new LongFinder(bytes, options);
        }
        return new MultiLongFinder(bytes, options);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private static class QuickMultiLongStates
    extends MultiLongBitMapStates {
        private long[][] bytes;

        public QuickMultiLongStates(byte[] pattern) {
            this.bytes = QuickMultiLongStates.computeStates(pattern);
        }

        private static long[][] computeStates(byte[] pattern) {
            int i;
            long[][] bytes = new long[256][];
            for (i = 0; i < bytes.length; ++i) {
                bytes[i] = QuickMultiLongStates.computeZero(pattern.length);
            }
            for (i = 0; i < pattern.length; ++i) {
                byte b = pattern[i];
                int j = pattern.length - i - 1;
                int slot = (pattern.length - 1) / 64 - j / 64;
                int offset = j % 64;
                long[] lArray = bytes[b & 0xFF];
                int n = slot;
                lArray[n] = lArray[n] | 1L << offset;
            }
            return bytes;
        }

        @Override
        public long[] all(byte b) {
            return this.bytes[b & 0xFF];
        }
    }

    private static abstract class MultiLongBitMapStates
    implements BitMapStates {
        private MultiLongBitMapStates() {
        }

        public static long[] computeZero(int length) {
            return new long[(length - 1) / 64 + 1];
        }

        @Override
        public boolean supportsSingle() {
            return false;
        }

        @Override
        public long single(byte b) {
            throw new UnsupportedOperationException();
        }
    }

    private static class QuickSingleLongStates
    extends SingleLongBitMapStates {
        private long[] bytes;

        public QuickSingleLongStates(byte[] pattern) {
            this.bytes = QuickSingleLongStates.computeStates(pattern);
        }

        private static long[] computeStates(byte[] pattern) {
            long[] bytes = new long[256];
            for (int i = 0; i < pattern.length; ++i) {
                byte b = pattern[i];
                int j = pattern.length - i - 1;
                int n = b & 0xFF;
                bytes[n] = bytes[n] | 1L << j;
            }
            return bytes;
        }

        @Override
        public long single(byte b) {
            return this.bytes[b & 0xFF];
        }
    }

    private static abstract class SingleLongBitMapStates
    implements BitMapStates {
        private SingleLongBitMapStates() {
        }

        @Override
        public boolean supportsSingle() {
            return true;
        }

        @Override
        public long[] all(byte b) {
            return new long[]{this.single(b)};
        }
    }

    public static class Factory
    implements StringSearchAlgorithmFactory {
        private Charset charset;

        public Factory() {
            this(StandardCharsets.UTF_16LE);
        }

        public Factory(Charset charset) {
            this.charset = charset;
        }

        @Override
        public StringSearchAlgorithm of(String pattern) {
            return new BNDM(pattern, this.charset);
        }
    }

    private class MultiLongFinder
    extends Finder {
        private long[] state;

        public MultiLongFinder(ByteProvider bytes, StringFinderOption ... options) {
            super(bytes, options);
            this.state = this.initial(BNDM.this.patternLength);
        }

        private long[] initial(int patternLength) {
            return this.init(new long[(patternLength - 1) / 64 + 1]);
        }

        private long[] init(long[] state) {
            Arrays.fill(state, -1L);
            state[0] = this.activeStates;
            return state;
        }

        @Override
        public void skipTo(long pos) {
            if (pos > this.bytes.current()) {
                this.bytes.move(pos);
            }
            this.init(this.state);
        }

        @Override
        public StringMatch findNext() {
            while (!this.bytes.finished(BNDM.this.patternLength - 1)) {
                this.state = this.initial(BNDM.this.patternLength);
                int j = BNDM.this.patternLength - 1;
                int last = BNDM.this.patternLength;
                while (this.zero(this.state)) {
                    byte currentByte = this.bytes.lookahead(j);
                    long[] all = BNDM.this.states.all(currentByte);
                    this.state = this.join(this.state, all);
                    if ((this.state[0] & this.finalstate) != 0L) {
                        if (j > 0) {
                            last = j;
                        } else {
                            StringMatch createMatch = this.createMatch();
                            this.bytes.forward(last);
                            return createMatch;
                        }
                    }
                    --j;
                    this.state = this.next(this.state);
                }
                this.bytes.forward(last);
            }
            return null;
        }

        private long[] next(long[] state) {
            for (int i = 0; i < state.length; ++i) {
                int j = i + 1;
                long leastBit = j < state.length ? state[j] >>> 63 : 0L;
                state[i] = state[i] << 1 | leastBit;
            }
            state[0] = state[0] & this.activeStates;
            return state;
        }

        private boolean zero(long[] state) {
            for (int i = 0; i < state.length; ++i) {
                if (state[i] == 0L) continue;
                return true;
            }
            return false;
        }

        private long[] join(long[] state, long[] bits) {
            for (int i = 0; i < state.length; ++i) {
                state[i] = state[i] & bits[i];
            }
            return state;
        }
    }

    private class LongFinder
    extends Finder {
        private long state;

        public LongFinder(ByteProvider bytes, StringFinderOption ... options) {
            super(bytes, options);
            this.state = this.activeStates;
        }

        @Override
        public void skipTo(long pos) {
            if (pos > this.bytes.current()) {
                this.bytes.move(pos);
            }
            this.state = this.activeStates;
        }

        @Override
        public StringMatch findNext() {
            while (!this.bytes.finished(BNDM.this.patternLength - 1)) {
                this.state = this.activeStates;
                int j = BNDM.this.patternLength - 1;
                int last = BNDM.this.patternLength;
                while (this.state != 0L) {
                    byte currentByte = this.bytes.lookahead(j);
                    long single = BNDM.this.states.single(currentByte);
                    this.state &= single;
                    if ((this.state & this.finalstate) != 0L) {
                        if (j > 0) {
                            last = j;
                        } else {
                            StringMatch createMatch = this.createMatch();
                            this.bytes.forward(last);
                            return createMatch;
                        }
                    }
                    --j;
                    this.state = this.state << 1 & this.activeStates;
                }
                this.bytes.forward(last);
            }
            return null;
        }
    }

    private abstract class Finder
    extends AbstractStringFinder {
        protected final long finalstate;
        protected final long activeStates;
        protected ByteProvider bytes;

        public Finder(ByteProvider bytes, StringFinderOption ... options) {
            super(options);
            this.finalstate = 1L << (BNDM.this.patternLength - 1) % 64;
            this.activeStates = this.finalstate - 1L | this.finalstate;
            this.bytes = bytes;
        }

        protected StringMatch createMatch() {
            long start = this.bytes.current();
            long end = start + (long)BNDM.this.patternLength;
            ByteString s = this.bytes.slice(start, end);
            return new StringMatch(start, end, s.getString());
        }
    }
}

