/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.patternsearch.chars;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.amygdalum.stringsearchalgorithms.io.CharProvider;
import net.amygdalum.stringsearchalgorithms.patternsearch.chars.FactorExtender;
import net.amygdalum.stringsearchalgorithms.patternsearch.chars.FactorExtenderFactory;
import net.amygdalum.stringsearchalgorithms.search.BufferedStringFinder;
import net.amygdalum.stringsearchalgorithms.search.MatchOption;
import net.amygdalum.stringsearchalgorithms.search.StringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinderOption;
import net.amygdalum.stringsearchalgorithms.search.StringMatch;
import net.amygdalum.stringsearchalgorithms.search.chars.EmptyMatchFinder;
import net.amygdalum.stringsearchalgorithms.search.chars.MultiStringSearchAlgorithmFactory;
import net.amygdalum.stringsearchalgorithms.search.chars.StringSearchAlgorithm;
import net.amygdalum.stringsearchalgorithms.search.chars.StringSearchAlgorithmFactory;

public class MultiFactorRE
implements StringSearchAlgorithm {
    private static final int DEFAULT_MAX_LENGTH = 3;
    private int minLength;
    private StringSearchAlgorithm searchAlgorithm;
    private Map<String, List<FactorExtender>> extenders;

    public MultiFactorRE(MultiStringSearchAlgorithmFactory factorSearcher, FactorExtenderFactory factorExtender, String ... patterns) {
        this(factorSearcher, factorExtender, 3, Arrays.asList(patterns));
    }

    public MultiFactorRE(MultiStringSearchAlgorithmFactory factorSearcher, FactorExtenderFactory factorExtender, int maxLength, String ... patterns) {
        this(factorSearcher, factorExtender, maxLength, Arrays.asList(patterns));
    }

    public MultiFactorRE(MultiStringSearchAlgorithmFactory factorSearcher, FactorExtenderFactory factorExtender, Collection<String> patterns) {
        this(factorSearcher, factorExtender, 3, patterns);
    }

    public MultiFactorRE(MultiStringSearchAlgorithmFactory factorSearcher, FactorExtenderFactory factorExtender, int maxLength, Collection<String> patterns) {
        Map<String, FactorExtender> matchers = MultiFactorRE.computeMatchers(patterns, factorExtender);
        this.minLength = MultiFactorRE.computeMinLength(matchers);
        this.extenders = MultiFactorRE.computeExtenders(matchers, this.minLength, maxLength);
        this.searchAlgorithm = factorSearcher.of(this.extenders.keySet());
    }

    private static Map<String, FactorExtender> computeMatchers(Collection<String> patterns, FactorExtenderFactory factorExtender) {
        LinkedHashMap<String, FactorExtender> matchers = new LinkedHashMap<String, FactorExtender>();
        for (String pattern : patterns) {
            matchers.put(pattern, factorExtender.of(pattern));
        }
        return matchers;
    }

    private static int computeMinLength(Map<String, FactorExtender> matchers) {
        int minLength = Integer.MAX_VALUE;
        for (FactorExtender matcher : matchers.values()) {
            minLength = Math.min(minLength, matcher.getPatternLength());
        }
        return minLength;
    }

    private static Map<String, List<FactorExtender>> computeExtenders(Map<String, FactorExtender> matchers, int minLength, int length) {
        LinkedHashMap<String, List<FactorExtender>> factors = new LinkedHashMap<String, List<FactorExtender>>();
        Collection<FactorExtender> allMatchers = matchers.values();
        for (FactorExtender matcher : allMatchers) {
            List<String> newFactors = matcher.getBestFactors(length);
            for (String string : newFactors) {
                ArrayList<FactorExtender> matchersByFactor = (ArrayList<FactorExtender>)factors.get(string);
                if (matchersByFactor == null) {
                    matchersByFactor = new ArrayList<FactorExtender>();
                    factors.put(string, matchersByFactor);
                }
                matchersByFactor.add(matcher.forFactor(string));
            }
            if (matcher.getPatternLength() != 0) continue;
            ArrayList<FactorExtender> matchersByFactor = (ArrayList<FactorExtender>)factors.get("");
            if (matchersByFactor == null) {
                matchersByFactor = new ArrayList<FactorExtender>();
                factors.put("", matchersByFactor);
            }
            matchersByFactor.add(matcher.forFactor(""));
        }
        for (FactorExtender matcher : allMatchers) {
            String pattern = matcher.getPattern();
            for (Map.Entry entry : factors.entrySet()) {
                String factor = (String)entry.getKey();
                List extenders = (List)entry.getValue();
                Set<String> patterns = MultiFactorRE.getPatterns(extenders);
                if (patterns.contains(pattern) || !matcher.hasFactor(factor)) continue;
                extenders.add(matcher.forFactor(factor));
            }
        }
        return factors;
    }

    private static Set<String> getPatterns(List<FactorExtender> extenders) {
        LinkedHashSet<String> patterns = new LinkedHashSet<String>();
        for (FactorExtender extender : extenders) {
            patterns.add(extender.getPattern());
        }
        return patterns;
    }

    @Override
    public StringFinder createFinder(CharProvider chars, StringFinderOption ... options) {
        return new Finder(chars, options);
    }

    @Override
    public int getPatternLength() {
        return this.minLength;
    }

    public String toString() {
        LinkedHashSet<String> factors = new LinkedHashSet<String>();
        for (List<FactorExtender> matchExtenders : this.extenders.values()) {
            for (FactorExtender matchExtender : matchExtenders) {
                factors.add(matchExtender.toString());
            }
        }
        return this.getClass().getSimpleName() + "<" + this.searchAlgorithm.toString() + ", " + factors + ">";
    }

    public static class Factory
    implements StringSearchAlgorithmFactory,
    MultiStringSearchAlgorithmFactory {
        private MultiStringSearchAlgorithmFactory factorSearcher;
        private FactorExtenderFactory factorExtender;
        private int maxLength;

        public Factory(MultiStringSearchAlgorithmFactory factorSearcher, FactorExtenderFactory factorExtender, int maxLength) {
            this.factorSearcher = factorSearcher;
            this.factorExtender = factorExtender;
            this.maxLength = maxLength;
        }

        @Override
        public StringSearchAlgorithm of(String pattern) {
            return new MultiFactorRE(this.factorSearcher, this.factorExtender, this.maxLength, pattern);
        }

        @Override
        public StringSearchAlgorithm of(Collection<String> patterns) {
            return new MultiFactorRE(this.factorSearcher, this.factorExtender, this.maxLength, patterns);
        }
    }

    private class Finder
    extends BufferedStringFinder {
        private StringFinder searchFactors;
        private boolean longest;
        private boolean nonEmpty;
        private CharProvider chars;
        private long lastStart;
        private long lastEnd;

        public Finder(CharProvider chars, StringFinderOption ... options) {
            super(options);
            this.searchFactors = MultiFactorRE.this.searchAlgorithm.createFinder(chars, options);
            if (MultiFactorRE.this.minLength == 0) {
                this.searchFactors = new EmptyMatchFinder(this.searchFactors, chars, options);
            }
            this.longest = MatchOption.LONGEST_MATCH.in(options);
            this.nonEmpty = MatchOption.NON_EMPTY.in(options);
            this.chars = chars;
            this.lastStart = 0L;
            this.lastEnd = -1L;
        }

        @Override
        public void skipTo(long pos) {
            this.removeMatchesBefore(pos);
            if (this.lastStart < pos) {
                this.lastStart = pos;
            }
            if (this.lastStart > this.chars.current()) {
                this.searchFactors.skipTo(this.lastStart);
            }
        }

        @Override
        public StringMatch findNext() {
            StringMatch match;
            long firstStart = this.lastStart;
            long currentStart = this.lastStart;
            while (!this.chars.finished() && (this.isBufferEmpty() || currentStart == firstStart) && (match = this.searchFactors.findNext()) != null) {
                if (firstStart == this.lastStart) {
                    firstStart = match.start();
                }
                currentStart = match.start();
                this.extend(match);
            }
            if (this.chars.finished() && this.isBufferEmpty() && (match = this.searchFactors.findNext()) != null) {
                this.extend(match);
            }
            this.lastStart = currentStart;
            if (!this.isBufferEmpty()) {
                StringMatch current;
                if (this.longest) {
                    current = this.longestLeftMost();
                    this.lastEnd = current.end();
                    return current;
                }
                current = this.leftMost();
                this.lastEnd = current.end();
                return current;
            }
            return null;
        }

        private void extend(StringMatch match) {
            List matchers = (List)MultiFactorRE.this.extenders.get(match.text());
            for (FactorExtender matcher : matchers) {
                long pos = this.chars.current();
                this.chars.move(match.end());
                for (StringMatch extendedMatch : matcher.extendFactor(this.chars, this.longest)) {
                    if (extendedMatch.start() < this.lastStart || extendedMatch.start() <= this.lastStart && extendedMatch.end() <= this.lastEnd || this.longest && extendedMatch.end() <= this.lastEnd || this.nonEmpty && extendedMatch.isEmpty()) continue;
                    this.push(extendedMatch);
                }
                this.chars.move(pos);
            }
        }
    }
}

