/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.util.text;

import java.util.Collection;
import java.util.List;

public final class CharUtils {
    private CharUtils() {
    }

    public static boolean isAsciiPrintable(char ch) {
        return ch >= ' ' && ch < '\u007f';
    }

    public static String charToString(char ch) {
        if (CharUtils.isAsciiPrintable(ch)) {
            return String.valueOf(ch);
        }
        StringBuilder buffer = new StringBuilder("\\u");
        String hex = Integer.toHexString(ch);
        for (int i = 0; i < 4 - hex.length(); ++i) {
            buffer.append('0');
        }
        buffer.append(hex);
        return buffer.toString();
    }

    public static char after(char c) {
        return (char)(c + '\u0001');
    }

    public static char before(char c) {
        return (char)(c - '\u0001');
    }

    public static char computeMinChar(char[] pattern) {
        char min = '\uffff';
        for (int i = 0; i < pattern.length; ++i) {
            if (pattern[i] >= min) continue;
            min = pattern[i];
        }
        return min;
    }

    public static char computeMinChar(Collection<char[]> patterns) {
        char min = '\uffff';
        for (char[] pattern : patterns) {
            for (int i = 0; i < pattern.length; ++i) {
                if (pattern[i] >= min) continue;
                min = pattern[i];
            }
        }
        return min;
    }

    public static char computeMaxChar(char[] pattern) {
        char max = '\u0000';
        for (int i = 0; i < pattern.length; ++i) {
            if (pattern[i] <= max) continue;
            max = pattern[i];
        }
        return max;
    }

    public static char computeMaxChar(Collection<char[]> patterns) {
        char max = '\u0000';
        for (char[] pattern : patterns) {
            for (int i = 0; i < pattern.length; ++i) {
                if (pattern[i] <= max) continue;
                max = pattern[i];
            }
        }
        return max;
    }

    public static int minLength(List<char[]> patterns) {
        int len = Integer.MAX_VALUE;
        for (char[] pattern : patterns) {
            if (pattern.length >= len) continue;
            len = pattern.length;
        }
        return len;
    }

    public static int maxLength(List<char[]> patterns) {
        int len = Integer.MIN_VALUE;
        for (char[] pattern : patterns) {
            if (pattern.length <= len) continue;
            len = pattern.length;
        }
        return len;
    }
}

