/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.util.map;

import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.amygdalum.util.map.TuneableMap;

public class CharObjectMap<T>
extends TuneableMap {
    private static final char NULL_KEY = '\u0000';
    private float loadFactor;
    private int mask;
    private int expandAt;
    private int size;
    private char[] keys;
    private T[] values;
    private T defaultValue;
    private T nullValue;

    public CharObjectMap(T defaultValue) {
        this(16, 0.7f, defaultValue);
    }

    public CharObjectMap(int initialSize, float loadFactor, T defaultValue) {
        this.loadFactor = loadFactor;
        this.mask = CharObjectMap.mask(initialSize, loadFactor);
        this.expandAt = initialSize;
        this.size = 0;
        this.keys = new char[this.mask + 1];
        this.values = new Object[this.mask + 1];
        this.defaultValue = defaultValue;
        this.nullValue = defaultValue;
    }

    public char[] keys() {
        int size = this.size;
        if (this.nullValue != this.defaultValue) {
            ++size;
        }
        char[] keys = new char[size];
        int pos = 0;
        for (char c : this.keys) {
            if (c == '\u0000') continue;
            keys[pos] = c;
            ++pos;
        }
        if (this.nullValue != this.defaultValue && pos < keys.length) {
            keys[pos] = '\u0000';
        }
        Arrays.sort(keys);
        return keys;
    }

    public CharObjectMap<T> add(char key, T value) {
        this.put(key, value);
        return this;
    }

    public void put(char key, T value) {
        if (key == '\u0000') {
            this.nullValue = value;
            return;
        }
        int slot = CharObjectMap.hash(key) & this.mask;
        while (this.keys[slot] != key && this.keys[slot] != '\u0000') {
            slot = slot + 1 & this.mask;
        }
        if (this.keys[slot] == '\u0000') {
            ++this.size;
        }
        this.keys[slot] = key;
        this.values[slot] = value;
        if (this.size > this.expandAt) {
            this.expand(this.size * 2);
        }
    }

    public T get(char key) {
        if (key == '\u0000') {
            return this.nullValue;
        }
        int slot = CharObjectMap.hash(key) & this.mask;
        while (this.keys[slot] != key && this.keys[slot] != '\u0000') {
            slot = slot + 1 & this.mask;
        }
        if (this.keys[slot] == '\u0000') {
            return this.defaultValue;
        }
        return this.values[slot];
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public Iterable<Entry> entries() {
        return new EntryIterable();
    }

    private void expand(int size) {
        int i;
        int mask = CharObjectMap.mask(size, this.loadFactor);
        char[] oldkeys = this.keys;
        T[] oldvalues = this.values;
        char[] keys = new char[mask + 1];
        Object[] values = new Object[mask + 1];
        int[] delayed = new int[this.size];
        int pos = 0;
        for (i = 0; i < oldkeys.length; ++i) {
            char key = oldkeys[i];
            if (key == '\u0000') continue;
            T value = oldvalues[i];
            int slot = CharObjectMap.hash(key) & mask;
            if (keys[slot] == '\u0000') {
                keys[slot] = key;
                values[slot] = value;
                continue;
            }
            delayed[pos] = i;
            ++pos;
        }
        for (i = 0; i <= pos; ++i) {
            int j = delayed[i];
            char key = oldkeys[j];
            T value = oldvalues[j];
            int slot = CharObjectMap.hash(key) & mask;
            while (keys[slot] != key && keys[slot] != '\u0000') {
                slot = slot + 1 & mask;
            }
            keys[slot] = key;
            values[slot] = value;
        }
        this.expandAt = size;
        this.mask = mask;
        this.keys = keys;
        this.values = values;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("{\n");
        if (this.keys.length > 0) {
            char key = this.keys[0];
            T value = this.values[0];
            buffer.append(key).append(": ").append(value);
        }
        for (int i = 1; i < this.keys.length; ++i) {
            char key = this.keys[i];
            T value = this.values[i];
            buffer.append(",\n").append(key).append(": ").append(value);
        }
        buffer.append("\n}");
        return buffer.toString();
    }

    public class Entry {
        public char key;
        public T value;
    }

    public class EntryIterator
    implements Iterator<Entry> {
        private int index = 0;
        private int currentKey = -1;
        private int fixedSize;
        private Entry entry;

        public EntryIterator() {
            this.fixedSize = CharObjectMap.this.size;
            this.entry = new Entry();
        }

        @Override
        public boolean hasNext() {
            if (CharObjectMap.this.size != this.fixedSize) {
                throw new ConcurrentModificationException();
            }
            return this.index < this.fixedSize;
        }

        @Override
        public Entry next() {
            if (CharObjectMap.this.size != this.fixedSize) {
                throw new ConcurrentModificationException();
            }
            while (this.currentKey < CharObjectMap.this.keys.length - 1) {
                ++this.currentKey;
                char c = CharObjectMap.this.keys[this.currentKey];
                if (c == '\u0000') continue;
                this.entry.key = CharObjectMap.this.keys[this.currentKey];
                this.entry.value = CharObjectMap.this.values[this.currentKey];
                ++this.index;
                return this.entry;
            }
            if (CharObjectMap.this.nullValue != CharObjectMap.this.defaultValue) {
                this.entry.key = '\u0000';
                this.entry.value = CharObjectMap.this.nullValue;
                ++this.index;
                return this.entry;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.currentKey < 0 || this.currentKey >= CharObjectMap.this.keys.length) {
                throw new NoSuchElementException();
            }
            ((CharObjectMap)CharObjectMap.this).keys[this.currentKey] = '\u0000';
            ((CharObjectMap)CharObjectMap.this).values[this.currentKey] = CharObjectMap.this.defaultValue;
        }
    }

    public class EntryIterable
    implements Iterable<Entry> {
        @Override
        public Iterator<Entry> iterator() {
            return new EntryIterator();
        }
    }
}

