/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.search;

import net.amygdalum.util.map.CharObjectMap;

public class TrieNode<T> {
    private int min = 0;
    private int max = 3;
    private TrieNode<T>[] nexts = TrieNode.trieNodes(4);
    private CharObjectMap<TrieNode<T>> nextMap;
    private TrieNode<T> fallback;
    private String match;
    private T attached;

    private static <T> TrieNode<T>[] trieNodes(int len) {
        return new TrieNode[len];
    }

    public void addNext(char c, TrieNode<T> node) {
        if (this.nexts != null) {
            int newMin;
            if (c >= this.min && c <= this.max) {
                this.nexts[c - this.min] = node;
                return;
            }
            int newMax = c > this.max ? c : this.max;
            int newLen = newMax - (newMin = c < this.min ? c : this.min) + 1;
            if (newLen <= 256) {
                TrieNode<T>[] newNexts = TrieNode.trieNodes(newLen);
                int newOffset = this.min - newMin;
                for (int i = 0; i < this.nexts.length; ++i) {
                    newNexts[i + newOffset] = this.nexts[i];
                }
                newNexts[c - newMin] = node;
                this.min = newMin;
                this.max = newMax;
                this.nexts = newNexts;
                return;
            }
        }
        if (this.nextMap == null) {
            this.nextMap = new CharObjectMap<Object>(null);
            for (int i = 0; i < this.nexts.length; ++i) {
                TrieNode<T> nodeToMap = this.nexts[i];
                char charToMap = (char)(this.min + i);
                if (nodeToMap == null) continue;
                this.nextMap.put(charToMap, nodeToMap);
            }
            this.nexts = null;
        }
        this.nextMap.put((char)c, node);
    }

    public CharObjectMap<TrieNode<T>> getNexts() {
        if (this.nextMap != null) {
            return this.nextMap;
        }
        CharObjectMap<Object> map = new CharObjectMap<Object>(null);
        for (int i = 0; i < this.nexts.length; ++i) {
            TrieNode<T> nodeToMap = this.nexts[i];
            char charToMap = (char)(this.min + i);
            if (nodeToMap == null) continue;
            map.put(charToMap, nodeToMap);
        }
        return map;
    }

    public void addFallback(TrieNode<T> fallback) {
        this.fallback = fallback;
    }

    public TrieNode<T> getFallback() {
        return this.fallback;
    }

    public String getMatch() {
        return this.match;
    }

    public void setMatch(String match) {
        this.match = match;
    }

    public T getAttached() {
        return this.attached;
    }

    public void setAttached(T attached) {
        this.attached = attached;
    }

    public static char[] revert(char[] chars) {
        int ri = chars.length - 1;
        char[] reversechars = new char[chars.length];
        for (int i = 0; i < reversechars.length; ++i) {
            reversechars[i] = chars[ri - i];
        }
        return reversechars;
    }

    public TrieNode<T> extend(char[] chars) {
        TrieNode<T> node = this.extend(chars, 0);
        node.setMatch(new String(chars));
        return node;
    }

    public TrieNode<T> extend(char[] chars, int i) {
        if (i >= chars.length) {
            return this;
        }
        TrieNode<T> toExtend = this.findNodeToExtend(chars[i]);
        return toExtend.extend(chars, i + 1);
    }

    private TrieNode<T> findNodeToExtend(char current) {
        TrieNode<T> node = this.nextNode(current);
        if (node == null) {
            node = new TrieNode<T>();
            this.addNext(current, node);
        }
        return node;
    }

    public TrieNode<T> nextNode(char c) {
        if (this.nextMap != null) {
            return this.nextMap.get(c);
        }
        int index = c - this.min;
        if (index >= this.nexts.length || index < 0) {
            return null;
        }
        return this.nexts[index];
    }

    public TrieNode<T> nextNode(char[] chars) {
        TrieNode<T> current = this;
        for (char c : chars) {
            if ((current = current.nextNode(c)) != null) continue;
            return null;
        }
        return current;
    }

    public String toString() {
        if (this.match != null) {
            return '[' + this.match + ']';
        }
        return "[]";
    }
}

