/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.search;

import java.util.Arrays;
import net.amygdalum.stringsearchalgorithms.io.CharProvider;
import net.amygdalum.stringsearchalgorithms.search.AbstractStringFinder;
import net.amygdalum.stringsearchalgorithms.search.BitMapStates;
import net.amygdalum.stringsearchalgorithms.search.StringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinderOption;
import net.amygdalum.stringsearchalgorithms.search.StringMatch;
import net.amygdalum.stringsearchalgorithms.search.StringSearchAlgorithm;
import net.amygdalum.stringsearchalgorithms.search.StringSearchAlgorithmFactory;
import net.amygdalum.util.map.CharLongMap;
import net.amygdalum.util.map.CharObjectMap;
import net.amygdalum.util.text.CharUtils;

public class ShiftAnd
implements StringSearchAlgorithm {
    private int patternLength;
    private BitMapStates states;

    public ShiftAnd(String pattern) {
        this.patternLength = pattern.length();
        this.states = ShiftAnd.computeStates(pattern.toCharArray());
    }

    private static BitMapStates computeStates(char[] pattern) {
        if (ShiftAnd.isCompactRange(pattern)) {
            if (pattern.length > 64) {
                return new QuickMultiLongStates(pattern);
            }
            return new QuickSingleLongStates(pattern);
        }
        if (pattern.length > 64) {
            return new SmartMultiLongStates(pattern);
        }
        return new SmartSingleLongStates(pattern);
    }

    public static boolean isCompactRange(char[] pattern) {
        char minChar = CharUtils.computeMinChar(pattern);
        char maxChar = CharUtils.computeMaxChar(pattern);
        return maxChar - minChar < 256 || maxChar - minChar < pattern.length * 2;
    }

    @Override
    public int getPatternLength() {
        return this.patternLength;
    }

    @Override
    public StringFinder createFinder(CharProvider chars, StringFinderOption ... options) {
        if (this.states.supportsSingle()) {
            return new LongFinder(chars, options);
        }
        return new MultiLongFinder(chars, options);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private static class SmartMultiLongStates
    extends MultiLongBitMapStates {
        private CharObjectMap<long[]> states;

        public SmartMultiLongStates(char[] pattern) {
            this.states = SmartMultiLongStates.computeStates(pattern);
        }

        private static CharObjectMap<long[]> computeStates(char[] pattern) {
            long[] zero = SmartMultiLongStates.computeZero(pattern.length);
            CharObjectMap<long[]> map = new CharObjectMap<long[]>(zero);
            for (int i = 0; i < pattern.length; ++i) {
                char c = pattern[i];
                int slot = (pattern.length - 1) / 64 - i / 64;
                int offset = i % 64;
                long[] newState = map.get(c);
                if (newState == zero) {
                    newState = SmartMultiLongStates.computeZero(pattern.length);
                }
                int n = slot;
                newState[n] = newState[n] | 1L << offset;
                map.put(c, newState);
            }
            return map;
        }

        @Override
        public long[] all(char c) {
            return this.states.get(c);
        }
    }

    private static class QuickMultiLongStates
    extends MultiLongBitMapStates {
        private char minChar;
        private char maxChar;
        private long[][] characters;
        private long[] zero;

        public QuickMultiLongStates(char[] pattern) {
            this.minChar = CharUtils.computeMinChar(pattern);
            this.maxChar = CharUtils.computeMaxChar(pattern);
            this.characters = QuickMultiLongStates.computeStates(pattern, this.minChar, this.maxChar);
            this.zero = QuickMultiLongStates.computeZero(pattern.length);
        }

        private static long[][] computeStates(char[] pattern, char min, char max) {
            long[][] characters = new long[max - min + 1][];
            for (int c = min; c <= max; ++c) {
                characters[c - min] = QuickMultiLongStates.computeZero(pattern.length);
            }
            for (int i = 0; i < pattern.length; ++i) {
                char c = pattern[i];
                int slot = (pattern.length - 1) / 64 - i / 64;
                int offset = i % 64;
                long[] lArray = characters[c - min];
                int n = slot;
                lArray[n] = lArray[n] | 1L << offset;
            }
            return characters;
        }

        @Override
        public long[] all(char c) {
            if (c < this.minChar || c > this.maxChar) {
                return this.zero;
            }
            return this.characters[c - this.minChar];
        }
    }

    private static abstract class MultiLongBitMapStates
    implements BitMapStates {
        private MultiLongBitMapStates() {
        }

        public static long[] computeZero(int length) {
            return new long[(length - 1) / 64 + 1];
        }

        @Override
        public boolean supportsSingle() {
            return false;
        }

        @Override
        public long single(char c) {
            throw new UnsupportedOperationException();
        }
    }

    private static class SmartSingleLongStates
    extends SingleLongBitMapStates {
        private CharLongMap states;

        public SmartSingleLongStates(char[] pattern) {
            this.states = SmartSingleLongStates.computeStates(pattern);
        }

        private static CharLongMap computeStates(char[] pattern) {
            CharLongMap map = new CharLongMap(0L);
            for (int i = 0; i < pattern.length; ++i) {
                char c = pattern[i];
                long newState = map.get(c) | 1L << i;
                map.put(c, newState);
            }
            return map;
        }

        @Override
        public long single(char c) {
            return this.states.get(c);
        }
    }

    private static class QuickSingleLongStates
    extends SingleLongBitMapStates {
        private char minChar;
        private char maxChar;
        private long[] characters;

        public QuickSingleLongStates(char[] pattern) {
            this.minChar = CharUtils.computeMinChar(pattern);
            this.maxChar = CharUtils.computeMaxChar(pattern);
            this.characters = QuickSingleLongStates.computeStates(pattern, this.minChar, this.maxChar);
        }

        private static long[] computeStates(char[] pattern, char min, char max) {
            long[] characters = new long[max - min + 1];
            for (int i = 0; i < pattern.length; ++i) {
                char c = pattern[i];
                int n = c - min;
                characters[n] = characters[n] | 1L << i;
            }
            return characters;
        }

        @Override
        public long single(char c) {
            if (c < this.minChar || c > this.maxChar) {
                return 0L;
            }
            return this.characters[c - this.minChar];
        }
    }

    private static abstract class SingleLongBitMapStates
    implements BitMapStates {
        private SingleLongBitMapStates() {
        }

        @Override
        public boolean supportsSingle() {
            return true;
        }

        @Override
        public long[] all(char c) {
            return new long[]{this.single(c)};
        }
    }

    public static class Factory
    implements StringSearchAlgorithmFactory {
        @Override
        public StringSearchAlgorithm of(String pattern) {
            return new ShiftAnd(pattern);
        }
    }

    private class MultiLongFinder
    extends Finder {
        private long[] state;

        public MultiLongFinder(CharProvider chars, StringFinderOption ... options) {
            super(chars, options);
            this.state = new long[(ShiftAnd.this.patternLength - 1) / 64 + 1];
        }

        @Override
        public void skipTo(long pos) {
            this.chars.move(pos);
            Arrays.fill(this.state, 0L);
        }

        @Override
        public StringMatch findNext() {
            while (!this.chars.finished()) {
                char nextChar = this.chars.next();
                long[] bits = ShiftAnd.this.states.all(nextChar);
                this.state = this.next(this.state, bits);
                if ((this.state[0] & this.finalstate) == 0L) continue;
                return this.createMatch();
            }
            return null;
        }

        private long[] next(long[] state, long[] bits) {
            for (int i = 0; i < state.length; ++i) {
                int j = i + 1;
                long leastBit = j < state.length ? state[j] >>> 63 : 1L;
                state[i] = (state[i] << 1 | leastBit) & bits[i];
            }
            return state;
        }
    }

    private class LongFinder
    extends Finder {
        private long state;

        public LongFinder(CharProvider chars, StringFinderOption ... options) {
            super(chars, options);
            this.state = 0L;
        }

        @Override
        public void skipTo(long pos) {
            this.chars.move(pos);
            this.state = 0L;
        }

        @Override
        public StringMatch findNext() {
            while (!this.chars.finished()) {
                char nextChar = this.chars.next();
                long bits = ShiftAnd.this.states.single(nextChar);
                this.state = (this.state << 1 | 1L) & bits;
                if ((this.state & this.finalstate) == 0L) continue;
                return this.createMatch();
            }
            return null;
        }
    }

    private abstract class Finder
    extends AbstractStringFinder {
        protected final long finalstate;
        protected CharProvider chars;

        public Finder(CharProvider chars, StringFinderOption ... options) {
            super(options);
            this.finalstate = 1L << (ShiftAnd.this.patternLength - 1) % 64;
            this.chars = chars;
        }

        protected StringMatch createMatch() {
            long end = this.chars.current();
            long start = end - (long)ShiftAnd.this.patternLength;
            String s = this.chars.slice(start, end);
            return new StringMatch(start, end, s);
        }
    }
}

