/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.search;

import java.util.Collection;
import java.util.List;
import net.amygdalum.stringsearchalgorithms.io.CharProvider;
import net.amygdalum.stringsearchalgorithms.search.BufferedStringFinder;
import net.amygdalum.stringsearchalgorithms.search.CharShift;
import net.amygdalum.stringsearchalgorithms.search.MatchOption;
import net.amygdalum.stringsearchalgorithms.search.MultiStringSearchAlgorithmFactory;
import net.amygdalum.stringsearchalgorithms.search.StringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinderOption;
import net.amygdalum.stringsearchalgorithms.search.StringMatch;
import net.amygdalum.stringsearchalgorithms.search.StringSearchAlgorithm;
import net.amygdalum.stringsearchalgorithms.search.TrieNode;
import net.amygdalum.util.map.CharIntMap;
import net.amygdalum.util.text.CharUtils;
import net.amygdalum.util.text.StringUtils;

public class SetHorspool
implements StringSearchAlgorithm {
    private TrieNode<Void> trie;
    private int minLength;
    private int maxLength;
    private CharShift charShift;

    public SetHorspool(Collection<String> patterns) {
        this(patterns, false);
    }

    public SetHorspool(Collection<String> patterns, boolean relaxed) {
        List<char[]> charpatterns = StringUtils.toCharArray(patterns);
        this.trie = SetHorspool.computeTrie(charpatterns);
        this.minLength = CharUtils.minLength(charpatterns);
        this.maxLength = CharUtils.maxLength(charpatterns);
        this.charShift = this.computeCharacterShift(charpatterns, this.minLength, relaxed);
    }

    private CharShift computeCharacterShift(List<char[]> charpatterns, int minLength, boolean relaxed) {
        if (this.isCompactRange(charpatterns, minLength)) {
            return new QuickShift(charpatterns, minLength);
        }
        if (relaxed) {
            return new RelaxedShift(charpatterns, minLength);
        }
        return new SmartShift(charpatterns, minLength);
    }

    public boolean isCompactRange(List<char[]> charpatterns, int minLength) {
        char minChar = CharUtils.computeMinChar(charpatterns);
        char maxChar = CharUtils.computeMaxChar(charpatterns);
        return maxChar - minChar < 256 || maxChar - minChar < minLength * 2;
    }

    private static TrieNode<Void> computeTrie(List<char[]> charpatterns) {
        TrieNode<Void> trie = new TrieNode<Void>();
        for (char[] pattern : charpatterns) {
            TrieNode<Void> node = trie.extend(TrieNode.revert(pattern), 0);
            node.setMatch(new String(pattern));
        }
        return trie;
    }

    @Override
    public StringFinder createFinder(CharProvider chars, StringFinderOption ... options) {
        if (MatchOption.LONGEST_MATCH.in(options)) {
            return new LongestMatchFinder(chars, options);
        }
        return new NextMatchFinder(chars, options);
    }

    @Override
    public int getPatternLength() {
        return this.minLength;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private static class SmartShift
    implements CharShift {
        private CharIntMap characterShift;

        public SmartShift(List<char[]> charpatterns, int minLength) {
            this.characterShift = SmartShift.computeCharacterShift(charpatterns, minLength);
        }

        private static CharIntMap computeCharacterShift(List<char[]> patterns, int minLength) {
            CharIntMap map = new CharIntMap(minLength);
            for (char[] pattern : patterns) {
                for (int i = 0; i < pattern.length - 1; ++i) {
                    int value = map.get(pattern[i]);
                    map.put(pattern[i], Math.min(value, pattern.length - i - 1));
                }
            }
            return map;
        }

        @Override
        public int getShift(char c) {
            return this.characterShift.get(c);
        }
    }

    private static class RelaxedShift
    implements CharShift {
        private int[] characterShift;

        public RelaxedShift(List<char[]> charpatterns, int minLength) {
            this.characterShift = RelaxedShift.computeCharacterShift(charpatterns, minLength);
        }

        private static int[] computeCharacterShift(List<char[]> patterns, int minLength) {
            int[] characters = new int[256];
            for (int i = 0; i < characters.length; ++i) {
                characters[i] = minLength;
            }
            for (char[] pattern : patterns) {
                for (int i = 0; i < pattern.length - 1; ++i) {
                    int newShift = pattern.length - i - 1;
                    int index = pattern[i] % 256;
                    if (newShift >= characters[index]) continue;
                    characters[index] = newShift;
                }
            }
            return characters;
        }

        @Override
        public int getShift(char c) {
            return this.characterShift[c % 256];
        }
    }

    private static class QuickShift
    implements CharShift {
        private char minChar;
        private char maxChar;
        private int[] characterShift;
        private int defaultShift;

        public QuickShift(List<char[]> charpatterns, int minLength) {
            this.minChar = CharUtils.computeMinChar(charpatterns);
            this.maxChar = CharUtils.computeMaxChar(charpatterns);
            this.characterShift = QuickShift.computeCharacterShift(charpatterns, minLength, CharUtils.computeMinChar(charpatterns), CharUtils.computeMaxChar(charpatterns));
            this.defaultShift = minLength;
        }

        private static int[] computeCharacterShift(List<char[]> patterns, int minLength, char min, char max) {
            int[] characters = new int[max - min + 1];
            for (int i = 0; i < characters.length; ++i) {
                characters[i] = minLength;
            }
            for (char[] pattern : patterns) {
                for (int i = 0; i < pattern.length - 1; ++i) {
                    characters[pattern[i] - min] = Math.min(characters[pattern[i] - min], pattern.length - i - 1);
                }
            }
            return characters;
        }

        @Override
        public int getShift(char c) {
            if (c < this.minChar || c > this.maxChar) {
                return this.defaultShift;
            }
            return this.characterShift[c - this.minChar];
        }
    }

    public static class Factory
    implements MultiStringSearchAlgorithmFactory {
        private boolean relaxed;

        public Factory() {
            this(false);
        }

        public Factory(boolean relaxed) {
            this.relaxed = relaxed;
        }

        @Override
        public StringSearchAlgorithm of(Collection<String> patterns) {
            return new SetHorspool(patterns, this.relaxed);
        }
    }

    private class LongestMatchFinder
    extends Finder {
        public LongestMatchFinder(CharProvider chars, StringFinderOption ... options) {
            super(chars, options);
        }

        @Override
        public StringMatch findNext() {
            long lastStart = this.lastStartFromBuffer();
            int lookahead = SetHorspool.this.minLength - 1;
            while (!this.chars.finished(lookahead)) {
                int patternPointer = lookahead;
                long pos = this.chars.current();
                char current = this.chars.lookahead(patternPointer);
                for (TrieNode node = SetHorspool.this.trie.nextNode(current); node != null; node = node.nextNode(this.chars.lookahead(patternPointer))) {
                    String match = node.getMatch();
                    if (match != null) {
                        StringMatch stringMatch = this.createMatch(patternPointer, match);
                        if (lastStart < 0L) {
                            lastStart = stringMatch.start();
                        }
                        this.push(stringMatch);
                    }
                    if (pos + (long)(--patternPointer) < 0L) break;
                }
                this.chars.forward(SetHorspool.this.charShift.getShift(current));
                if (!this.bufferContainsLongestMatch(lastStart)) continue;
                break;
            }
            return this.longestLeftMost();
        }

        public boolean bufferContainsLongestMatch(long lastStart) {
            return !this.isBufferEmpty() && this.chars.current() - lastStart - 1L > (long)(SetHorspool.this.maxLength - SetHorspool.this.minLength);
        }
    }

    private abstract class Finder
    extends BufferedStringFinder {
        protected CharProvider chars;

        public Finder(CharProvider chars, StringFinderOption ... options) {
            super(options);
            this.chars = chars;
        }

        @Override
        public void skipTo(long pos) {
            long last = this.removeMatchesBefore(pos);
            this.chars.move(last);
        }

        protected StringMatch createMatch(int patternPointer, String s) {
            long start = this.chars.current() + (long)patternPointer;
            long end = this.chars.current() + (long)SetHorspool.this.minLength;
            return new StringMatch(start, end, s);
        }
    }

    private class NextMatchFinder
    extends Finder {
        public NextMatchFinder(CharProvider chars, StringFinderOption ... options) {
            super(chars, options);
        }

        @Override
        public StringMatch findNext() {
            if (!this.isBufferEmpty()) {
                return this.leftMost();
            }
            int lookahead = SetHorspool.this.minLength - 1;
            while (!this.chars.finished(lookahead)) {
                int patternPointer = lookahead;
                long pos = this.chars.current();
                char current = this.chars.lookahead(patternPointer);
                for (TrieNode node = SetHorspool.this.trie.nextNode(current); node != null; node = node.nextNode(this.chars.lookahead(patternPointer))) {
                    String match = node.getMatch();
                    if (match != null) {
                        this.push(this.createMatch(patternPointer, match));
                    }
                    if (pos + (long)(--patternPointer) < 0L) break;
                }
                this.chars.forward(SetHorspool.this.charShift.getShift(current));
                if (this.isBufferEmpty()) continue;
                return this.leftMost();
            }
            return null;
        }
    }
}

