/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import net.amygdalum.stringsearchalgorithms.io.CharProvider;
import net.amygdalum.stringsearchalgorithms.search.AbstractStringFinder;
import net.amygdalum.stringsearchalgorithms.search.MultiStringSearchAlgorithmFactory;
import net.amygdalum.stringsearchalgorithms.search.StringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinderOption;
import net.amygdalum.stringsearchalgorithms.search.StringMatch;
import net.amygdalum.stringsearchalgorithms.search.StringSearchAlgorithm;
import net.amygdalum.stringsearchalgorithms.search.TrieNode;
import net.amygdalum.util.map.CharObjectMap;
import net.amygdalum.util.text.CharUtils;
import net.amygdalum.util.text.StringUtils;

public class SetBackwardOracleMatching
implements StringSearchAlgorithm {
    private TrieNode<List<String>> trie;
    private int minLength;

    public SetBackwardOracleMatching(Collection<String> patterns) {
        List<char[]> charpatterns = StringUtils.toCharArray(patterns);
        this.minLength = CharUtils.minLength(charpatterns);
        this.trie = SetBackwardOracleMatching.computeTrie(charpatterns, this.minLength);
    }

    private static TrieNode<List<String>> computeTrie(List<char[]> charpatterns, int length) {
        TrieNode<List<String>> trie = new TrieNode<List<String>>();
        for (char[] pattern : charpatterns) {
            char[] prefix;
            boolean terminate = pattern.length == (prefix = Arrays.copyOfRange(pattern, 0, length)).length;
            TrieNode<List<String>> node = trie.extend(TrieNode.revert(prefix), 0);
            if (!terminate) continue;
            node.setMatch(new String(prefix));
        }
        SetBackwardOracleMatching.computeOracle(trie);
        SetBackwardOracleMatching.computeTerminals(trie, charpatterns, length);
        return trie;
    }

    private static void computeOracle(TrieNode<List<String>> trie) {
        IdentityHashMap<TrieNode<List<String>>, TrieNode<List<String>>> oracle = new IdentityHashMap<TrieNode<List<String>>, TrieNode<List<String>>>();
        TrieNode<List<String>> init = trie;
        oracle.put(init, null);
        LinkedList<TrieNode<List<String>>> worklist = new LinkedList<TrieNode<List<String>>>();
        worklist.add(trie);
        while (!worklist.isEmpty()) {
            TrieNode current = (TrieNode)worklist.remove();
            List<TrieNode<List<String>>> nexts = SetBackwardOracleMatching.process(current, oracle, init);
            worklist.addAll(nexts);
        }
    }

    private static List<TrieNode<List<String>>> process(TrieNode<List<String>> parent, Map<TrieNode<List<String>>, TrieNode<List<String>>> oracle, TrieNode<List<String>> init) {
        ArrayList<TrieNode<List<String>>> nexts = new ArrayList<TrieNode<List<String>>>();
        for (CharObjectMap.Entry entry : parent.getNexts().entries()) {
            char c = entry.key;
            TrieNode trie = (TrieNode)entry.value;
            TrieNode<List<String>> down = oracle.get(parent);
            while (down != null && down.nextNode(c) == null) {
                down.addNext(c, trie);
                down = oracle.get(down);
            }
            if (down != null) {
                TrieNode<List<String>> next = down.nextNode(c);
                oracle.put(trie, next);
            } else {
                oracle.put(trie, init);
            }
            nexts.add(trie);
        }
        return nexts;
    }

    private static void computeTerminals(TrieNode<List<String>> trie, List<char[]> patterns, int minLength) {
        for (char[] pattern : patterns) {
            String stringPattern = new String(pattern);
            String prefix = stringPattern.substring(0, minLength);
            TrieNode<List<String>> terminal = trie.nextNode(TrieNode.revert(prefix.toCharArray()));
            List<String> terminalPatterns = terminal.getAttached();
            if (terminalPatterns == null) {
                terminalPatterns = new ArrayList<String>();
                terminal.setAttached(terminalPatterns);
                terminalPatterns.add(prefix);
            }
            terminalPatterns.add(stringPattern.substring(minLength));
        }
    }

    @Override
    public StringFinder createFinder(CharProvider chars, StringFinderOption ... options) {
        return new Finder(chars, options);
    }

    @Override
    public int getPatternLength() {
        return this.minLength;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Factory
    implements MultiStringSearchAlgorithmFactory {
        @Override
        public StringSearchAlgorithm of(Collection<String> patterns) {
            return new SetBackwardOracleMatching(patterns);
        }
    }

    private class Finder
    extends AbstractStringFinder {
        private CharProvider chars;
        private Queue<StringMatch> buffer;

        public Finder(CharProvider chars, StringFinderOption ... options) {
            super(options);
            this.chars = chars;
            this.buffer = new LinkedList<StringMatch>();
        }

        @Override
        public void skipTo(long pos) {
            this.chars.move(pos);
            this.buffer.clear();
        }

        @Override
        public StringMatch findNext() {
            if (!this.buffer.isEmpty()) {
                return this.buffer.remove();
            }
            int lookahead = SetBackwardOracleMatching.this.minLength - 1;
            while (!this.chars.finished(lookahead)) {
                List patterns;
                Iterator iPatterns;
                String prefix;
                int j;
                TrieNode current = SetBackwardOracleMatching.this.trie;
                for (j = lookahead; j >= 0 && current != null; current = current.nextNode(this.chars.lookahead(j)), --j) {
                }
                long currentWindowStart = this.chars.current();
                long currentPos = currentWindowStart + (long)j + 1L;
                long currentWindowEnd = currentWindowStart + (long)SetBackwardOracleMatching.this.minLength;
                String matchedPrefix = this.chars.slice(currentPos, currentWindowEnd);
                if (current != null && j < 0 && (prefix = (String)(iPatterns = (patterns = (List)current.getAttached()).iterator()).next()).equals(matchedPrefix)) {
                    while (iPatterns.hasNext()) {
                        String suffix = (String)iPatterns.next();
                        long currentWordEnd = currentWindowEnd + (long)suffix.length();
                        if (this.chars.finished((int)(currentWordEnd - currentWindowStart - 1L)) || !this.chars.slice(currentWindowEnd, currentWordEnd).equals(suffix)) continue;
                        this.buffer.add(this.createMatch(currentWindowStart, currentWordEnd, prefix + suffix));
                    }
                    this.chars.next();
                    if (this.buffer.isEmpty()) continue;
                    return this.buffer.remove();
                }
                if (j <= 0) {
                    this.chars.next();
                    continue;
                }
                this.chars.forward(j + 1);
            }
            return null;
        }

        public StringMatch createMatch(long start, long end, String match) {
            return new StringMatch(start, end, match);
        }
    }
}

