/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.search;

import net.amygdalum.stringsearchalgorithms.io.CharProvider;
import net.amygdalum.stringsearchalgorithms.search.AbstractStringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinderOption;
import net.amygdalum.stringsearchalgorithms.search.StringMatch;
import net.amygdalum.stringsearchalgorithms.search.StringSearchAlgorithm;
import net.amygdalum.stringsearchalgorithms.search.StringSearchAlgorithmFactory;

public class KnuthMorrisPratt
implements StringSearchAlgorithm {
    private char[] pattern;
    private int patternLength;
    private int[] next;

    public KnuthMorrisPratt(String pattern) {
        this.pattern = pattern.toCharArray();
        this.patternLength = this.pattern.length;
        this.next = this.computeNext(this.pattern);
    }

    private int[] computeNext(char[] pattern) {
        int[] next = new int[this.patternLength + 1];
        next[0] = -1;
        int patternPointer = 0;
        int suffixPointer = -1;
        while (patternPointer < this.patternLength) {
            while (suffixPointer > -1 && pattern[patternPointer] != pattern[suffixPointer]) {
                suffixPointer = next[suffixPointer];
            }
            if (++patternPointer < this.patternLength && pattern[patternPointer] == pattern[++suffixPointer]) {
                next[patternPointer] = next[suffixPointer];
                continue;
            }
            next[patternPointer] = suffixPointer;
        }
        return next;
    }

    @Override
    public int getPatternLength() {
        return this.patternLength;
    }

    @Override
    public StringFinder createFinder(CharProvider chars, StringFinderOption ... options) {
        return new Finder(chars, options);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Factory
    implements StringSearchAlgorithmFactory {
        @Override
        public StringSearchAlgorithm of(String pattern) {
            return new KnuthMorrisPratt(pattern);
        }
    }

    private class Finder
    extends AbstractStringFinder {
        private CharProvider chars;
        private int patternPointer;

        public Finder(CharProvider chars, StringFinderOption ... options) {
            super(options);
            this.chars = chars;
            this.patternPointer = 0;
        }

        @Override
        public void skipTo(long pos) {
            this.chars.move(pos);
            this.patternPointer = 0;
        }

        @Override
        public StringMatch findNext() {
            while (!this.chars.finished()) {
                char nextChar = this.chars.next();
                while (this.patternPointer > -1 && KnuthMorrisPratt.this.pattern[this.patternPointer] != nextChar) {
                    this.patternPointer = KnuthMorrisPratt.this.next[this.patternPointer];
                }
                ++this.patternPointer;
                if (this.patternPointer < KnuthMorrisPratt.this.patternLength) continue;
                int match = this.patternPointer;
                this.patternPointer = KnuthMorrisPratt.this.next[this.patternPointer];
                return this.createMatch(match);
            }
            return null;
        }

        private StringMatch createMatch(int match) {
            long end = this.chars.current();
            long start = end - (long)match;
            String s = this.chars.slice(start, end);
            return new StringMatch(start, end, s);
        }
    }
}

