/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.search;

import net.amygdalum.stringsearchalgorithms.io.CharProvider;
import net.amygdalum.stringsearchalgorithms.search.BufferedStringFinder;
import net.amygdalum.stringsearchalgorithms.search.MatchOption;
import net.amygdalum.stringsearchalgorithms.search.StringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinderOption;
import net.amygdalum.stringsearchalgorithms.search.StringMatch;

public class EmptyMatchFinder
extends BufferedStringFinder {
    private StringFinder finder;
    private CharProvider chars;
    private boolean longest;

    public EmptyMatchFinder(StringFinder finder, CharProvider chars, StringFinderOption ... options) {
        super(options);
        this.finder = finder;
        this.chars = chars;
        this.longest = MatchOption.LONGEST_MATCH.in(options);
    }

    @Override
    public StringMatch findNext() {
        if (this.isBufferEmpty()) {
            long start = this.chars.current();
            StringMatch next = this.finder.findNext();
            if (next != null) {
                this.push(next);
                for (long pos = start; pos < next.start(); ++pos) {
                    this.push(new StringMatch(pos, pos, ""));
                }
            } else {
                for (long pos = start; pos < this.chars.current(); ++pos) {
                    this.push(new StringMatch(pos, pos, ""));
                }
            }
        }
        if (this.longest) {
            return this.longestLeftMost();
        }
        return this.leftMost();
    }

    @Override
    public void skipTo(long pos) {
        this.finder.skipTo(pos);
        this.clear();
    }
}

