/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.search;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.amygdalum.stringsearchalgorithms.io.CharProvider;
import net.amygdalum.stringsearchalgorithms.search.AbstractStringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinderOption;
import net.amygdalum.stringsearchalgorithms.search.StringMatch;
import net.amygdalum.stringsearchalgorithms.search.StringSearchAlgorithm;
import net.amygdalum.stringsearchalgorithms.search.StringSearchAlgorithmFactory;
import net.amygdalum.stringsearchalgorithms.search.TrieNode;
import net.amygdalum.util.map.CharObjectMap;

public class BOM
implements StringSearchAlgorithm {
    private TrieNode<String> trie;
    private int patternLength;

    public BOM(String pattern) {
        this.patternLength = pattern.length();
        this.trie = BOM.computeTrie(pattern.toCharArray(), this.patternLength);
    }

    private static TrieNode<String> computeTrie(char[] pattern, int length) {
        TrieNode<String> trie = new TrieNode<String>();
        TrieNode node = trie.extend(TrieNode.revert(pattern), 0);
        node.setMatch(new String(pattern));
        BOM.computeOracle(trie);
        return trie;
    }

    private static void computeOracle(TrieNode<String> trie) {
        IdentityHashMap<TrieNode<String>, TrieNode<String>> oracle = new IdentityHashMap<TrieNode<String>, TrieNode<String>>();
        TrieNode<String> init = trie;
        oracle.put(init, null);
        LinkedList<TrieNode<String>> worklist = new LinkedList<TrieNode<String>>();
        worklist.add(trie);
        while (!worklist.isEmpty()) {
            TrieNode current = (TrieNode)worklist.remove();
            List<TrieNode<String>> nexts = BOM.process(current, oracle, init);
            worklist.addAll(nexts);
        }
    }

    private static List<TrieNode<String>> process(TrieNode<String> parent, Map<TrieNode<String>, TrieNode<String>> oracle, TrieNode<String> init) {
        ArrayList<TrieNode<String>> nexts = new ArrayList<TrieNode<String>>();
        for (CharObjectMap.Entry entry : parent.getNexts().entries()) {
            char c = entry.key;
            TrieNode trie = (TrieNode)entry.value;
            TrieNode<String> down = oracle.get(parent);
            while (down != null && down.nextNode(c) == null) {
                down.addNext(c, trie);
                down = oracle.get(down);
            }
            if (down != null) {
                TrieNode<String> next = down.nextNode(c);
                oracle.put(trie, next);
            } else {
                oracle.put(trie, init);
            }
            nexts.add(trie);
        }
        return nexts;
    }

    @Override
    public int getPatternLength() {
        return this.patternLength;
    }

    @Override
    public StringFinder createFinder(CharProvider chars, StringFinderOption ... options) {
        return new Finder(chars, options);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Factory
    implements StringSearchAlgorithmFactory {
        @Override
        public StringSearchAlgorithm of(String pattern) {
            return new BOM(pattern);
        }
    }

    private class Finder
    extends AbstractStringFinder {
        private CharProvider chars;

        public Finder(CharProvider chars, StringFinderOption ... options) {
            super(options);
            this.chars = chars;
        }

        @Override
        public void skipTo(long pos) {
            this.chars.move(pos);
        }

        @Override
        public StringMatch findNext() {
            int lookahead = BOM.this.patternLength - 1;
            while (!this.chars.finished(lookahead)) {
                int j;
                TrieNode current = BOM.this.trie;
                for (j = lookahead; j >= 0 && current != null; current = current.nextNode(this.chars.lookahead(j)), --j) {
                }
                if (current != null && j < 0) {
                    String pattern = current.getMatch();
                    long currentWindowStart = this.chars.current();
                    StringMatch match = this.createMatch(currentWindowStart, pattern);
                    this.chars.next();
                    return match;
                }
                if (j <= 0) {
                    this.chars.next();
                    continue;
                }
                this.chars.forward(j + 1);
            }
            return null;
        }

        public StringMatch createMatch(long start, String match) {
            return new StringMatch(start, start + (long)match.length(), match);
        }
    }
}

