/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.amygdalum.stringsearchalgorithms.io.CharProvider;
import net.amygdalum.stringsearchalgorithms.search.BufferedStringFinder;
import net.amygdalum.stringsearchalgorithms.search.MatchOption;
import net.amygdalum.stringsearchalgorithms.search.MultiStringSearchAlgorithmFactory;
import net.amygdalum.stringsearchalgorithms.search.StringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinderOption;
import net.amygdalum.stringsearchalgorithms.search.StringMatch;
import net.amygdalum.stringsearchalgorithms.search.StringSearchAlgorithm;
import net.amygdalum.stringsearchalgorithms.search.TrieNode;
import net.amygdalum.util.map.CharObjectMap;
import net.amygdalum.util.text.CharUtils;
import net.amygdalum.util.text.StringUtils;

public class AhoCorasick
implements StringSearchAlgorithm {
    private TrieNode<Void> trie;
    private int minLength;

    public AhoCorasick(Collection<String> patterns) {
        List<char[]> charpatterns = StringUtils.toCharArray(patterns);
        this.trie = AhoCorasick.computeTrie(charpatterns);
        this.minLength = CharUtils.minLength(charpatterns);
    }

    private static TrieNode<Void> computeTrie(List<char[]> charpatterns) {
        TrieNode<Void> trie = new TrieNode<Void>();
        for (char[] pattern : charpatterns) {
            trie.extend(pattern);
        }
        return AhoCorasick.computeSupportTransition(trie);
    }

    @Override
    public StringFinder createFinder(CharProvider chars, StringFinderOption ... options) {
        if (MatchOption.LONGEST_MATCH.in(options)) {
            return new LongestMatchFinder(chars, options);
        }
        return new NextMatchFinder(chars, options);
    }

    @Override
    public int getPatternLength() {
        return this.minLength;
    }

    private static TrieNode<Void> computeSupportTransition(TrieNode<Void> trie) {
        LinkedList<TrieNode> worklist = new LinkedList<TrieNode>();
        worklist.add(trie);
        while (!worklist.isEmpty()) {
            TrieNode current = (TrieNode)worklist.remove();
            for (CharObjectMap.Entry next : current.getNexts().entries()) {
                TrieNode nextTrie = (TrieNode)next.value;
                AhoCorasick.computeSupport(current, next.key, nextTrie, trie);
                worklist.add(nextTrie);
            }
        }
        return trie;
    }

    private static void computeSupport(TrieNode<Void> parent, char c, TrieNode<Void> trie, TrieNode<Void> init) {
        if (parent != null && trie instanceof TrieNode) {
            TrieNode<Void> down;
            for (down = parent.getFallback(); down != null && down.nextNode(c) == null; down = down.getFallback()) {
            }
            if (down != null) {
                TrieNode<Void> next = down.nextNode(c);
                trie.addFallback(next);
                String nextMatch = next.getMatch();
                if (nextMatch != null && trie.getMatch() == null) {
                    trie.setMatch(nextMatch);
                }
            } else {
                trie.addFallback(init);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Factory
    implements MultiStringSearchAlgorithmFactory {
        @Override
        public StringSearchAlgorithm of(Collection<String> patterns) {
            return new AhoCorasick(patterns);
        }
    }

    private class LongestMatchFinder
    extends Finder {
        public LongestMatchFinder(CharProvider chars, StringFinderOption ... options) {
            super(chars, options);
        }

        @Override
        public StringMatch findNext() {
            while (!this.chars.finished()) {
                TrieNode nextcurrent;
                char c = this.chars.next();
                TrieNode next = this.current.nextNode(c);
                if (next == null && !this.isBufferEmpty()) {
                    this.chars.prev();
                    break;
                }
                while (next == null && (nextcurrent = this.current.getFallback()) != null) {
                    this.current = nextcurrent;
                    next = this.current.nextNode(c);
                }
                this.current = next != null ? next : AhoCorasick.this.trie;
                if (this.current.getMatch() == null) continue;
                this.push(this.createMatches(this.current, this.chars.current()));
            }
            return this.longestLeftMost();
        }
    }

    private class NextMatchFinder
    extends Finder {
        public NextMatchFinder(CharProvider chars, StringFinderOption ... options) {
            super(chars, options);
        }

        @Override
        public StringMatch findNext() {
            if (!this.isBufferEmpty()) {
                return this.leftMost();
            }
            while (!this.chars.finished()) {
                TrieNode nextcurrent;
                char c = this.chars.next();
                TrieNode next = this.current.nextNode(c);
                while (next == null && (nextcurrent = this.current.getFallback()) != null) {
                    this.current = nextcurrent;
                    next = this.current.nextNode(c);
                }
                this.current = next != null ? next : AhoCorasick.this.trie;
                if (this.current.getMatch() == null) continue;
                this.push(this.createMatches(this.current, this.chars.current()));
                return this.leftMost();
            }
            return null;
        }
    }

    private abstract class Finder
    extends BufferedStringFinder {
        protected CharProvider chars;
        protected TrieNode<Void> current;

        public Finder(CharProvider chars, StringFinderOption ... options) {
            super(options);
            this.chars = chars;
            this.current = AhoCorasick.this.trie;
        }

        @Override
        public void skipTo(long pos) {
            this.chars.move(pos);
            this.current = AhoCorasick.this.trie;
            this.clear();
        }

        protected List<StringMatch> createMatches(TrieNode<Void> current, long end) {
            ArrayList<StringMatch> matches = new ArrayList<StringMatch>();
            while (current != null) {
                StringMatch nextMatch;
                String currentMatch = current.getMatch();
                if (currentMatch != null && !matches.contains(nextMatch = this.createMatch(end, currentMatch))) {
                    matches.add(nextMatch);
                }
                current = current.getFallback();
            }
            return matches;
        }

        protected StringMatch createMatch(long end, String s) {
            long start = end - (long)s.length();
            return new StringMatch(start, end, s);
        }
    }
}

