/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.regex;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.amygdalum.stringsearchalgorithms.regex.AbstractCharClassNode;
import net.amygdalum.stringsearchalgorithms.regex.AlternativesNode;
import net.amygdalum.stringsearchalgorithms.regex.AnyCharNode;
import net.amygdalum.stringsearchalgorithms.regex.BoundedLoopNode;
import net.amygdalum.stringsearchalgorithms.regex.CharClassBuilder;
import net.amygdalum.stringsearchalgorithms.regex.CharClassNode;
import net.amygdalum.stringsearchalgorithms.regex.CharNode;
import net.amygdalum.stringsearchalgorithms.regex.ConcatNode;
import net.amygdalum.stringsearchalgorithms.regex.DefinedCharNode;
import net.amygdalum.stringsearchalgorithms.regex.EmptyNode;
import net.amygdalum.stringsearchalgorithms.regex.GroupNode;
import net.amygdalum.stringsearchalgorithms.regex.OptionalNode;
import net.amygdalum.stringsearchalgorithms.regex.RangeCharNode;
import net.amygdalum.stringsearchalgorithms.regex.RegexCompileException;
import net.amygdalum.stringsearchalgorithms.regex.RegexNode;
import net.amygdalum.stringsearchalgorithms.regex.RegexParserOption;
import net.amygdalum.stringsearchalgorithms.regex.SingleCharNode;
import net.amygdalum.stringsearchalgorithms.regex.SpecialCharClassNode;
import net.amygdalum.stringsearchalgorithms.regex.UnboundedLoopNode;

public class RegexParser {
    private static final char OR = '|';
    private static final char AND = '&';
    private static final char OBRK = '[';
    private static final char NOT = '^';
    private static final char DASH = '-';
    private static final char CBRK = ']';
    private static final char OBRC = '{';
    private static final char COMMA = ',';
    private static final char CBRC = '}';
    private static final char OPT = '?';
    private static final char STAR = '*';
    private static final char PLUS = '+';
    private static final char OPAR = '(';
    private static final char CPAR = ')';
    private static final char DOT = '.';
    private static final char ESCAPE = '\\';
    private static final char[] DIGIT = "0123456789".toCharArray();
    private static final char[] BREAK_CONCAT = new char[]{'|', '&', ')'};
    private static final char[] OPEN_LOOP = new char[]{'?', '*', '+', '{'};
    private static final char[] CLOSE_CHAR_CLASS = new char[]{']'};
    private static final char DEFAULT_MIN_CHAR = '\u0000';
    private static final char DEFAULT_MAX_CHAR = '\u00ff';
    private Map<Character, CharNode> characterClasses;
    private String pattern;
    private int pos;
    private char min;
    private char max;
    private RegexParserOption[] options;

    public RegexParser(String pattern, RegexParserOption ... options) {
        this(pattern, '\u0000', '\u00ff', options);
    }

    public RegexParser(String pattern, char min, char max, RegexParserOption ... options) {
        this.pattern = pattern;
        this.min = min;
        this.max = max;
        this.options = options;
        this.pos = 0;
        this.characterClasses = new CharClassBuilder(min, max).add('t', new SingleCharNode('\t')).add('n', new SingleCharNode('\n')).add('r', new SingleCharNode('\r')).add('f', new SingleCharNode('\f')).add('\\', new SingleCharNode('\\')).add(RegexParser.createWhiteSpaceEscapes()).add(RegexParser.createAlphaNumericEscapes()).add(RegexParser.createDigitEscapes()).build();
    }

    private static SpecialCharClassNode createWhiteSpaceEscapes() {
        return new SpecialCharClassNode('s', new SingleCharNode(' '), new SingleCharNode('\t'), new SingleCharNode('\r'), new SingleCharNode('\n'));
    }

    private static SpecialCharClassNode createAlphaNumericEscapes() {
        return new SpecialCharClassNode('w', new RangeCharNode('0', '9'), new RangeCharNode('a', 'z'), new RangeCharNode('A', 'Z'));
    }

    private static SpecialCharClassNode createDigitEscapes() {
        return new SpecialCharClassNode('d', new RangeCharNode('0', '9'));
    }

    public RegexNode parse() {
        if (this.pattern == null) {
            return null;
        }
        if (this.pattern.isEmpty()) {
            return new EmptyNode();
        }
        return this.parseAlternatives();
    }

    private char next() {
        char ch = this.pattern.charAt(this.pos);
        ++this.pos;
        return ch;
    }

    private boolean done() {
        return this.pos >= this.pattern.length();
    }

    private boolean match(char c) {
        if (this.done()) {
            return false;
        }
        if (this.pattern.charAt(this.pos) == c) {
            ++this.pos;
            return true;
        }
        return false;
    }

    private boolean lookahead(char[] chars) {
        if (this.done()) {
            return false;
        }
        char current = this.pattern.charAt(this.pos);
        for (char c : chars) {
            if (c != current) continue;
            return true;
        }
        return false;
    }

    private boolean lookaheadIsDigit() {
        return this.lookahead(DIGIT);
    }

    private boolean lookaheadIsBreakConcat() {
        return this.lookahead(BREAK_CONCAT) || this.done();
    }

    private boolean lookaheadIsOpenLoop() {
        return this.lookahead(OPEN_LOOP);
    }

    private boolean lookaheadIsCloseCharClass() {
        return this.lookahead(CLOSE_CHAR_CLASS);
    }

    public RegexNode parseAlternatives() {
        RegexNode node = this.parseConcat();
        while (this.match('|')) {
            node = AlternativesNode.anyOf(node, this.parseConcat());
        }
        return node;
    }

    private RegexNode parseConcat() {
        LinkedList<RegexNode> nodes = new LinkedList<RegexNode>();
        nodes.add(this.parseLoop());
        while (!this.lookaheadIsBreakConcat()) {
            nodes.add(this.parseLoop());
        }
        return ConcatNode.inSequence(nodes.toArray(new RegexNode[0])).simplify();
    }

    private RegexNode parseLoop() {
        RegexNode node = this.parseCharOrCharClass();
        while (this.lookaheadIsOpenLoop()) {
            int from;
            if (this.match('?')) {
                node = OptionalNode.optional(node);
                continue;
            }
            if (this.match('*')) {
                node = UnboundedLoopNode.star(node);
                continue;
            }
            if (this.match('+')) {
                node = UnboundedLoopNode.plus(node);
                continue;
            }
            if (!this.match('{')) continue;
            int to = from = this.parseInt(0);
            if (this.match(',')) {
                to = this.parseInt(Integer.MIN_VALUE);
            }
            if (!this.match('}')) {
                throw new RegexCompileException(this.pattern, this.pos, "}");
            }
            if (to < 0) {
                node = UnboundedLoopNode.unbounded(node, from);
                continue;
            }
            node = BoundedLoopNode.bounded(node, from, to);
        }
        return node;
    }

    private RegexNode parseCharOrCharClass() {
        if (this.match('[')) {
            boolean complement = this.match('^');
            LinkedList<CharNode> subNodes = new LinkedList<CharNode>();
            subNodes.add(this.parseCharOrRange());
            while (!this.lookaheadIsCloseCharClass()) {
                subNodes.add(this.parseCharOrRange());
            }
            if (!this.match(']')) {
                throw new RegexCompileException(this.pattern, this.pos, "]");
            }
            AbstractCharClassNode charClassNode = new CharClassNode(RegexParser.toCharNodes(subNodes));
            if (complement) {
                charClassNode = ((AbstractCharClassNode)charClassNode).invert(this.min, this.max);
            }
            return charClassNode;
        }
        if (this.match('\\')) {
            return this.parseEscapedChar();
        }
        return this.parseLeaf();
    }

    private CharNode parseCharOrRange() {
        if (this.match('\\')) {
            return this.parseEscapedChar();
        }
        char ch = this.parseChar();
        if (this.match('-')) {
            if (this.lookaheadIsCloseCharClass()) {
                return new CharClassNode(new SingleCharNode(ch), new SingleCharNode('-'));
            }
            char from = ch;
            char to = this.parseChar();
            return new RangeCharNode(from, to).simplify();
        }
        return new SingleCharNode(ch);
    }

    private CharNode parseEscapedChar() {
        char ch = this.next();
        if (this.characterClasses.containsKey(Character.valueOf(ch))) {
            return this.characterClasses.get(Character.valueOf(ch));
        }
        return new SingleCharNode(ch);
    }

    private RegexNode parseLeaf() {
        if (this.match('.')) {
            if (RegexParserOption.DOT_ALL.in(this.options)) {
                return AnyCharNode.dotAll(this.min, this.max);
            }
            return AnyCharNode.dotDefault(this.min, this.max);
        }
        if (this.match('(')) {
            RegexNode node = this.parseAlternatives();
            if (!this.match(')')) {
                throw new RegexCompileException(this.pattern, this.pos, ")");
            }
            return new GroupNode(node);
        }
        return new SingleCharNode(this.parseChar());
    }

    private int parseInt(int defaultValue) {
        int start = this.pos;
        while (this.lookaheadIsDigit()) {
            this.next();
        }
        if (start != this.pos) {
            return Integer.parseInt(this.pattern.substring(start, this.pos));
        }
        return defaultValue;
    }

    private char parseChar() {
        if (this.done()) {
            throw new RegexCompileException(this.pattern, this.pos, ".");
        }
        return this.next();
    }

    public static List<DefinedCharNode> toCharNodes(List<CharNode> nodes) {
        ArrayList<DefinedCharNode> charNodes = new ArrayList<DefinedCharNode>();
        for (CharNode node : nodes) {
            charNodes.addAll(node.toCharNodes());
        }
        return charNodes;
    }
}

