/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.regex;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.amygdalum.stringsearchalgorithms.regex.DefinedCharNode;
import net.amygdalum.stringsearchalgorithms.regex.RangeCharNode;
import net.amygdalum.stringsearchalgorithms.regex.RegexNode;
import net.amygdalum.stringsearchalgorithms.regex.SingleCharNode;
import net.amygdalum.util.text.CharUtils;

public abstract class CharNode
implements RegexNode {
    public abstract List<DefinedCharNode> toCharNodes();

    @Override
    public CharNode clone() {
        try {
            return (CharNode)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public static List<DefinedCharNode> computeComplement(List<? extends DefinedCharNode> nodes, char min, char max) {
        Collections.sort(nodes);
        LinkedList<DefinedCharNode> remainderNodes = new LinkedList<DefinedCharNode>();
        char current = min;
        for (DefinedCharNode definedCharNode : nodes) {
            char from = definedCharNode.getFrom();
            char to = definedCharNode.getTo();
            if (current + '\u0001' == from) {
                remainderNodes.add(new SingleCharNode(current));
            } else if (current < from) {
                remainderNodes.add(new RangeCharNode(current, CharUtils.before(from)).simplify());
            }
            current = CharUtils.after(to);
        }
        if (current == max) {
            remainderNodes.add(new SingleCharNode(current));
        } else if (current != CharUtils.after(max) && current < max) {
            remainderNodes.add(new RangeCharNode(current, max).simplify());
        }
        return remainderNodes;
    }
}

