/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.search.chars;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import net.amygdalum.stringsearchalgorithms.io.CharProvider;
import net.amygdalum.stringsearchalgorithms.search.AbstractStringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinderOption;
import net.amygdalum.stringsearchalgorithms.search.StringMatch;
import net.amygdalum.stringsearchalgorithms.search.chars.MultiStringSearchAlgorithmFactory;
import net.amygdalum.stringsearchalgorithms.search.chars.StringSearchAlgorithm;
import net.amygdalum.stringsearchalgorithms.search.chars.SupportsCharClasses;
import net.amygdalum.util.map.CharObjectMap;
import net.amygdalum.util.text.CharMapping;
import net.amygdalum.util.text.CharUtils;
import net.amygdalum.util.text.StringUtils;
import net.amygdalum.util.tries.CharTrieNode;
import net.amygdalum.util.tries.CharTrieNodeCompiler;
import net.amygdalum.util.tries.PreCharTrieNode;

public class SetBackwardOracleMatching
implements StringSearchAlgorithm {
    private CharMapping mapping;
    private CharTrieNode<List<char[]>> trie;
    private int minLength;

    public SetBackwardOracleMatching(Collection<String> patterns) {
        this(patterns, CharMapping.IDENTITY);
    }

    public SetBackwardOracleMatching(Collection<String> patterns, CharMapping mapping) {
        List charpatterns = StringUtils.toCharArray(patterns);
        this.mapping = mapping;
        this.minLength = CharUtils.minLength((List)charpatterns);
        this.trie = SetBackwardOracleMatching.computeTrie(this.normalized(mapping, charpatterns), this.minLength, mapping);
    }

    private List<char[]> normalized(CharMapping mapping, List<char[]> charpatterns) {
        ArrayList<char[]> normalized = new ArrayList<char[]>(charpatterns.size());
        for (char[] cs : charpatterns) {
            normalized.add(mapping.normalized(cs));
        }
        return normalized;
    }

    private static void applyMapping(CharMapping mapping, PreCharTrieNode<List<char[]>> trie) {
        Set nodes = trie.nodes();
        for (PreCharTrieNode node : nodes) {
            SetBackwardOracleMatching.applyMapping((PreCharTrieNode<List<char[]>>)node, mapping);
        }
    }

    private static void applyMapping(PreCharTrieNode<List<char[]>> node, CharMapping mapping) {
        CharObjectMap nexts = node.getNexts();
        node.reset();
        for (CharObjectMap.Entry entry : nexts.cursor()) {
            char ec = entry.key;
            PreCharTrieNode next = (PreCharTrieNode)entry.value;
            for (char c : mapping.map(ec)) {
                node.addNext(c, next);
            }
        }
    }

    private static CharTrieNode<List<char[]>> computeTrie(List<char[]> charpatterns, int length, CharMapping mapping) {
        PreCharTrieNode trie = new PreCharTrieNode();
        for (char[] pattern : charpatterns) {
            char[] prefix = Arrays.copyOfRange(pattern, 0, length);
            trie.extend(CharUtils.revert((char[])prefix), 0);
        }
        SetBackwardOracleMatching.computeOracle((PreCharTrieNode<List<char[]>>)trie);
        SetBackwardOracleMatching.computeTerminals((PreCharTrieNode<List<char[]>>)trie, charpatterns, length);
        if (mapping != CharMapping.IDENTITY) {
            SetBackwardOracleMatching.applyMapping(mapping, (PreCharTrieNode<List<char[]>>)trie);
        }
        return new CharTrieNodeCompiler(false).compileAndLink(trie);
    }

    private static void computeOracle(PreCharTrieNode<List<char[]>> trie) {
        IdentityHashMap<PreCharTrieNode<List<char[]>>, PreCharTrieNode<List<char[]>>> oracle = new IdentityHashMap<PreCharTrieNode<List<char[]>>, PreCharTrieNode<List<char[]>>>();
        PreCharTrieNode<List<char[]>> init = trie;
        oracle.put(init, null);
        LinkedList<PreCharTrieNode<List<char[]>>> worklist = new LinkedList<PreCharTrieNode<List<char[]>>>();
        worklist.add(trie);
        while (!worklist.isEmpty()) {
            PreCharTrieNode current = (PreCharTrieNode)worklist.remove();
            List<PreCharTrieNode<List<char[]>>> nexts = SetBackwardOracleMatching.process((PreCharTrieNode<List<char[]>>)current, oracle, init);
            worklist.addAll(nexts);
        }
    }

    private static List<PreCharTrieNode<List<char[]>>> process(PreCharTrieNode<List<char[]>> parent, Map<PreCharTrieNode<List<char[]>>, PreCharTrieNode<List<char[]>>> oracle, PreCharTrieNode<List<char[]>> init) {
        ArrayList<PreCharTrieNode<List<char[]>>> nexts = new ArrayList<PreCharTrieNode<List<char[]>>>();
        for (CharObjectMap.Entry entry : parent.getNexts().cursor()) {
            char c = entry.key;
            PreCharTrieNode trie = (PreCharTrieNode)entry.value;
            PreCharTrieNode<List<char[]>> down = oracle.get(parent);
            while (down != null && down.nextNode(c) == null) {
                down.addNext(c, trie);
                down = oracle.get(down);
            }
            if (down != null) {
                PreCharTrieNode next = down.nextNode(c);
                oracle.put((PreCharTrieNode<List<char[]>>)trie, (PreCharTrieNode<List<char[]>>)next);
            } else {
                oracle.put((PreCharTrieNode<List<char[]>>)trie, init);
            }
            nexts.add((PreCharTrieNode<List<char[]>>)trie);
        }
        return nexts;
    }

    private static void computeTerminals(PreCharTrieNode<List<char[]>> trie, List<char[]> patterns, int minLength) {
        for (char[] pattern : patterns) {
            char[] prefix = Arrays.copyOfRange(pattern, 0, minLength);
            PreCharTrieNode terminal = trie.nextNode(CharUtils.revert((char[])prefix));
            ArrayList<char[]> terminalPatterns = (ArrayList<char[]>)terminal.getAttached();
            if (terminalPatterns == null) {
                terminalPatterns = new ArrayList<char[]>();
                terminal.setAttached(terminalPatterns);
                terminalPatterns.add(prefix);
            }
            char[] tail = Arrays.copyOfRange(pattern, minLength, pattern.length);
            terminalPatterns.add(tail);
        }
    }

    @Override
    public StringFinder createFinder(CharProvider chars, StringFinderOption ... options) {
        return new Finder(chars, options);
    }

    @Override
    public int getPatternLength() {
        return this.minLength;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Factory
    implements MultiStringSearchAlgorithmFactory,
    SupportsCharClasses {
        private CharMapping mapping;

        @Override
        public void enableCharClasses(CharMapping mapping) {
            this.mapping = mapping;
        }

        @Override
        public StringSearchAlgorithm of(Collection<String> patterns) {
            if (this.mapping == null) {
                return new SetBackwardOracleMatching(patterns);
            }
            return new SetBackwardOracleMatching(patterns, this.mapping);
        }
    }

    private class Finder
    extends AbstractStringFinder {
        private CharProvider chars;
        private Queue<StringMatch> buffer;

        public Finder(CharProvider chars, StringFinderOption ... options) {
            super(options);
            this.chars = chars;
            this.buffer = new LinkedList<StringMatch>();
        }

        @Override
        public void skipTo(long pos) {
            if (pos > this.chars.current()) {
                this.chars.move(pos);
            }
            this.buffer.clear();
        }

        @Override
        public StringMatch findNext() {
            if (!this.buffer.isEmpty()) {
                return this.buffer.remove();
            }
            int lookahead = SetBackwardOracleMatching.this.minLength - 1;
            while (!this.chars.finished(lookahead)) {
                List patterns;
                Iterator iPatterns;
                char[] prefix;
                int j;
                CharTrieNode current = SetBackwardOracleMatching.this.trie;
                for (j = lookahead; j >= 0 && current != null; current = current.nextNode(this.chars.lookahead(j)), --j) {
                }
                long currentWindowStart = this.chars.current();
                long currentPos = currentWindowStart + (long)j + 1L;
                long currentWindowEnd = currentWindowStart + (long)SetBackwardOracleMatching.this.minLength;
                char[] matchedPrefix = this.chars.between(currentPos, currentWindowEnd);
                if (current != null && j < 0 && Arrays.equals(prefix = (char[])(iPatterns = (patterns = (List)current.getAttached()).iterator()).next(), SetBackwardOracleMatching.this.mapping.normalized(matchedPrefix))) {
                    while (iPatterns.hasNext()) {
                        char[] suffix = (char[])iPatterns.next();
                        long currentWordEnd = currentWindowEnd + (long)suffix.length;
                        if (this.chars.finished((int)(currentWordEnd - currentWindowStart - 1L))) continue;
                        char[] matchedSuffix = this.chars.between(currentWindowEnd, currentWordEnd);
                        if (!Arrays.equals(suffix, SetBackwardOracleMatching.this.mapping.normalized(matchedSuffix))) continue;
                        this.buffer.add(this.createMatch(currentWindowStart, currentWordEnd));
                    }
                    this.chars.next();
                    if (this.buffer.isEmpty()) continue;
                    return this.buffer.remove();
                }
                if (j <= 0) {
                    this.chars.next();
                    continue;
                }
                this.chars.forward(j + 2);
            }
            return null;
        }

        private StringMatch createMatch(long start, long end) {
            String s = this.chars.slice(start, end);
            return new StringMatch(start, end, s);
        }
    }
}

