/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.search.chars;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.amygdalum.stringsearchalgorithms.io.CharProvider;
import net.amygdalum.stringsearchalgorithms.search.AbstractStringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinderOption;
import net.amygdalum.stringsearchalgorithms.search.StringMatch;
import net.amygdalum.stringsearchalgorithms.search.chars.StringSearchAlgorithm;
import net.amygdalum.stringsearchalgorithms.search.chars.StringSearchAlgorithmFactory;
import net.amygdalum.stringsearchalgorithms.search.chars.SupportsCharClasses;
import net.amygdalum.util.map.CharObjectMap;
import net.amygdalum.util.text.CharMapping;
import net.amygdalum.util.text.CharUtils;
import net.amygdalum.util.tries.CharTrieNode;
import net.amygdalum.util.tries.CharTrieNodeCompiler;
import net.amygdalum.util.tries.PreCharTrieNode;

public class BOM
implements StringSearchAlgorithm {
    private CharTrieNode<char[]> trie;
    private int patternLength;

    public BOM(String pattern) {
        this(pattern, CharMapping.IDENTITY);
    }

    public BOM(String pattern, CharMapping mapping) {
        this.patternLength = pattern.length();
        this.trie = BOM.computeTrie(mapping.normalized(pattern.toCharArray()), this.patternLength, mapping);
    }

    private static <T> void applyMapping(CharMapping mapping, PreCharTrieNode<char[]> trie) {
        Set nodes = trie.nodes();
        for (PreCharTrieNode node : nodes) {
            BOM.applyMapping((PreCharTrieNode<char[]>)node, mapping);
        }
    }

    private static void applyMapping(PreCharTrieNode<char[]> node, CharMapping mapping) {
        CharObjectMap nexts = node.getNexts();
        node.reset();
        for (CharObjectMap.Entry entry : nexts.cursor()) {
            char ec = entry.key;
            PreCharTrieNode next = (PreCharTrieNode)entry.value;
            for (char c : mapping.map(ec)) {
                node.addNext(c, next);
            }
        }
    }

    private static CharTrieNode<char[]> computeTrie(char[] pattern, int length, CharMapping mapping) {
        PreCharTrieNode trie = new PreCharTrieNode();
        PreCharTrieNode node = trie.extend(CharUtils.revert((char[])pattern), 0);
        node.setAttached((Object)pattern);
        BOM.computeOracle((PreCharTrieNode<char[]>)trie);
        if (mapping != CharMapping.IDENTITY) {
            BOM.applyMapping(mapping, (PreCharTrieNode<char[]>)trie);
        }
        return new CharTrieNodeCompiler(false).compileAndLink(trie);
    }

    private static void computeOracle(PreCharTrieNode<char[]> trie) {
        IdentityHashMap<PreCharTrieNode<char[]>, PreCharTrieNode<char[]>> oracle = new IdentityHashMap<PreCharTrieNode<char[]>, PreCharTrieNode<char[]>>();
        PreCharTrieNode<char[]> init = trie;
        oracle.put(init, null);
        LinkedList<PreCharTrieNode<char[]>> worklist = new LinkedList<PreCharTrieNode<char[]>>();
        worklist.add(trie);
        while (!worklist.isEmpty()) {
            PreCharTrieNode current = (PreCharTrieNode)worklist.remove();
            List<PreCharTrieNode<char[]>> nexts = BOM.process((PreCharTrieNode<char[]>)current, oracle, init);
            worklist.addAll(nexts);
        }
    }

    private static List<PreCharTrieNode<char[]>> process(PreCharTrieNode<char[]> parent, Map<PreCharTrieNode<char[]>, PreCharTrieNode<char[]>> oracle, PreCharTrieNode<char[]> init) {
        ArrayList<PreCharTrieNode<char[]>> nexts = new ArrayList<PreCharTrieNode<char[]>>();
        for (CharObjectMap.Entry entry : parent.getNexts().cursor()) {
            char c = entry.key;
            PreCharTrieNode trie = (PreCharTrieNode)entry.value;
            PreCharTrieNode<char[]> down = oracle.get(parent);
            while (down != null && down.nextNode(c) == null) {
                down.addNext(c, trie);
                down = oracle.get(down);
            }
            if (down != null) {
                PreCharTrieNode next = down.nextNode(c);
                oracle.put((PreCharTrieNode<char[]>)trie, (PreCharTrieNode<char[]>)next);
            } else {
                oracle.put((PreCharTrieNode<char[]>)trie, init);
            }
            nexts.add((PreCharTrieNode<char[]>)trie);
        }
        return nexts;
    }

    @Override
    public int getPatternLength() {
        return this.patternLength;
    }

    @Override
    public StringFinder createFinder(CharProvider chars, StringFinderOption ... options) {
        return new Finder(chars, options);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Factory
    implements StringSearchAlgorithmFactory,
    SupportsCharClasses {
        private CharMapping mapping;

        @Override
        public void enableCharClasses(CharMapping mapping) {
            this.mapping = mapping;
        }

        @Override
        public StringSearchAlgorithm of(String pattern) {
            if (this.mapping == null) {
                return new BOM(pattern);
            }
            return new BOM(pattern, this.mapping);
        }
    }

    private class Finder
    extends AbstractStringFinder {
        private CharProvider chars;

        public Finder(CharProvider chars, StringFinderOption ... options) {
            super(options);
            this.chars = chars;
        }

        @Override
        public void skipTo(long pos) {
            if (pos > this.chars.current()) {
                this.chars.move(pos);
            }
        }

        @Override
        public StringMatch findNext() {
            int lookahead = BOM.this.patternLength - 1;
            while (!this.chars.finished(lookahead)) {
                int j;
                CharTrieNode current = BOM.this.trie;
                for (j = lookahead; j >= 0 && current != null; current = current.nextNode(this.chars.lookahead(j)), --j) {
                }
                if (current != null && j < 0) {
                    char[] pattern = (char[])current.getAttached();
                    long start = this.chars.current();
                    long end = start + (long)pattern.length;
                    StringMatch match = this.createMatch(start, end);
                    this.chars.next();
                    return match;
                }
                if (j <= 0) {
                    this.chars.next();
                    continue;
                }
                this.chars.forward(j + 2);
            }
            return null;
        }

        private StringMatch createMatch(long start, long end) {
            String s = this.chars.slice(start, end);
            return new StringMatch(start, end, s);
        }
    }
}

