/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.io;

import net.amygdalum.stringsearchalgorithms.io.CharProvider;

public class ReverseCharProvider
implements CharProvider {
    private CharProvider chars;

    public ReverseCharProvider(CharProvider chars) {
        this.chars = chars;
    }

    @Override
    public char next() {
        return this.chars.prev();
    }

    @Override
    public char lookahead() {
        return this.chars.lookbehind();
    }

    @Override
    public char lookahead(int i) {
        return this.chars.lookbehind(i);
    }

    @Override
    public char prev() {
        return this.chars.next();
    }

    @Override
    public char lookbehind() {
        return this.chars.lookahead();
    }

    @Override
    public char lookbehind(int i) {
        return this.chars.lookahead(i);
    }

    @Override
    public long current() {
        return this.chars.current();
    }

    @Override
    public void move(long i) {
        this.chars.move(i);
    }

    @Override
    public void forward(int i) {
        this.chars.forward(-i);
    }

    @Override
    public void finish() {
        this.chars.move(0L);
    }

    @Override
    public char at(long i) {
        return this.chars.at(i);
    }

    @Override
    public boolean finished() {
        return this.chars.current() == 0L;
    }

    @Override
    public boolean finished(int i) {
        return this.chars.current() <= (long)i;
    }

    @Override
    public char[] between(long start, long end) {
        char[] between = this.chars.between(end, start);
        int reverseStart = between.length - 1;
        for (int i = 0; i < between.length / 2; ++i) {
            char temp = between[i];
            between[i] = between[reverseStart - i];
            between[reverseStart - i] = temp;
        }
        return between;
    }

    @Override
    public String slice(long start, long end) {
        return this.chars.slice(end, start);
    }

    @Override
    public void mark() {
        this.chars.mark();
    }

    @Override
    public boolean changed() {
        return this.chars.changed();
    }

    public String toString() {
        return new StringBuilder(this.chars.toString()).reverse().toString();
    }
}

