/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.search.bytes;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.amygdalum.stringsearchalgorithms.io.ByteProvider;
import net.amygdalum.stringsearchalgorithms.search.AbstractStringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinderOption;
import net.amygdalum.stringsearchalgorithms.search.StringMatch;
import net.amygdalum.stringsearchalgorithms.search.bytes.Encoding;
import net.amygdalum.stringsearchalgorithms.search.bytes.StringSearchAlgorithm;
import net.amygdalum.stringsearchalgorithms.search.bytes.StringSearchAlgorithmFactory;
import net.amygdalum.stringsearchalgorithms.search.bytes.TrieNode;
import net.amygdalum.util.map.ByteObjectMap;
import net.amygdalum.util.text.ByteString;
import net.amygdalum.util.text.ByteUtils;

public class BOM
implements StringSearchAlgorithm {
    private TrieNode<byte[]> trie;
    private int patternLength;

    public BOM(String pattern, Charset charset) {
        byte[] encoded = Encoding.encode(pattern, charset);
        this.patternLength = encoded.length;
        this.trie = BOM.computeTrie(encoded, this.patternLength);
    }

    private static TrieNode<byte[]> computeTrie(byte[] pattern, int length) {
        TrieNode<byte[]> trie = new TrieNode<byte[]>();
        TrieNode<byte[]> node = trie.extend(ByteUtils.revert(pattern), 0);
        node.setAttached(pattern);
        BOM.computeOracle(trie);
        return trie;
    }

    private static void computeOracle(TrieNode<byte[]> trie) {
        IdentityHashMap<TrieNode<byte[]>, TrieNode<byte[]>> oracle = new IdentityHashMap<TrieNode<byte[]>, TrieNode<byte[]>>();
        TrieNode<byte[]> init = trie;
        oracle.put(init, null);
        LinkedList<TrieNode<byte[]>> worklist = new LinkedList<TrieNode<byte[]>>();
        worklist.add(trie);
        while (!worklist.isEmpty()) {
            TrieNode current = (TrieNode)worklist.remove();
            List<TrieNode<byte[]>> nexts = BOM.process(current, oracle, init);
            worklist.addAll(nexts);
        }
    }

    private static List<TrieNode<byte[]>> process(TrieNode<byte[]> parent, Map<TrieNode<byte[]>, TrieNode<byte[]>> oracle, TrieNode<byte[]> init) {
        ArrayList<TrieNode<byte[]>> nexts = new ArrayList<TrieNode<byte[]>>();
        for (ByteObjectMap.Entry entry : parent.getNexts().cursor()) {
            byte b = entry.key;
            TrieNode trie = (TrieNode)entry.value;
            TrieNode<byte[]> down = oracle.get(parent);
            while (down != null && down.nextNode(b) == null) {
                down.addNext(b, trie);
                down = oracle.get(down);
            }
            if (down != null) {
                TrieNode<byte[]> next = down.nextNode(b);
                oracle.put(trie, next);
            } else {
                oracle.put(trie, init);
            }
            nexts.add(trie);
        }
        return nexts;
    }

    @Override
    public int getPatternLength() {
        return this.patternLength;
    }

    @Override
    public StringFinder createFinder(ByteProvider bytes, StringFinderOption ... options) {
        return new Finder(bytes, options);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Factory
    implements StringSearchAlgorithmFactory {
        private Charset charset;

        public Factory() {
            this(StandardCharsets.UTF_16LE);
        }

        public Factory(Charset charset) {
            this.charset = charset;
        }

        @Override
        public StringSearchAlgorithm of(String pattern) {
            return new BOM(pattern, this.charset);
        }
    }

    private class Finder
    extends AbstractStringFinder {
        private ByteProvider bytes;

        public Finder(ByteProvider bytes, StringFinderOption ... options) {
            super(options);
            this.bytes = bytes;
        }

        @Override
        public void skipTo(long pos) {
            if (pos > this.bytes.current()) {
                this.bytes.move(pos);
            }
        }

        @Override
        public StringMatch findNext() {
            int lookahead = BOM.this.patternLength - 1;
            while (!this.bytes.finished(lookahead)) {
                int j;
                TrieNode current = BOM.this.trie;
                for (j = lookahead; j >= 0 && current != null; current = current.nextNode(this.bytes.lookahead(j)), --j) {
                }
                if (current != null && j < 0) {
                    byte[] pattern = (byte[])current.getAttached();
                    long start = this.bytes.current();
                    long end = start + (long)pattern.length;
                    StringMatch match = this.createMatch(start, end);
                    this.bytes.next();
                    return match;
                }
                if (j <= 0) {
                    this.bytes.next();
                    continue;
                }
                this.bytes.forward(j + 2);
            }
            return null;
        }

        private StringMatch createMatch(long start, long end) {
            ByteString s = this.bytes.slice(start, end);
            return new StringMatch(start, end, s.getString());
        }
    }
}

