/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.patternsearch.chars;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import net.amygdalum.stringsearchalgorithms.io.CharProvider;
import net.amygdalum.stringsearchalgorithms.io.StringCharProvider;
import net.amygdalum.stringsearchalgorithms.patternsearch.chars.FactorExtender;
import net.amygdalum.stringsearchalgorithms.patternsearch.chars.FactorExtenderFactory;
import net.amygdalum.stringsearchalgorithms.patternsearch.chars.GlushkovAnalyzer;
import net.amygdalum.stringsearchalgorithms.patternsearch.chars.GlushkovAnalyzerOption;
import net.amygdalum.stringsearchalgorithms.patternsearch.chars.GlushkovAutomaton;
import net.amygdalum.stringsearchalgorithms.patternsearch.chars.GlushkovNormalizer;
import net.amygdalum.stringsearchalgorithms.patternsearch.chars.MatchBuilder;
import net.amygdalum.stringsearchalgorithms.patternsearch.chars.MatchListener;
import net.amygdalum.stringsearchalgorithms.regex.RegexNode;
import net.amygdalum.stringsearchalgorithms.regex.RegexParser;
import net.amygdalum.stringsearchalgorithms.regex.RegexParserOption;
import net.amygdalum.stringsearchalgorithms.search.StringMatch;

public class GlushkovPrefixExtender
implements FactorExtender {
    private String pattern;
    private GlushkovAutomaton automaton;
    private int minLength;
    private int prefixLength;
    private BitSet prefixInitial;

    public GlushkovPrefixExtender(String pattern) {
        RegexNode root = GlushkovPrefixExtender.parseAndNormalizeRegex(pattern);
        GlushkovAnalyzer analyzer = new GlushkovAnalyzer(root).analyze();
        this.pattern = pattern;
        this.automaton = analyzer.buildAutomaton(new GlushkovAnalyzerOption[0]);
        this.minLength = analyzer.minLength();
    }

    private GlushkovPrefixExtender(String pattern, GlushkovAutomaton automaton, int minLength, int prefixLength, BitSet prefixInitial) {
        this.pattern = pattern;
        this.automaton = automaton;
        this.minLength = minLength;
        this.prefixLength = prefixLength;
        this.prefixInitial = prefixInitial;
    }

    private static RegexNode parseAndNormalizeRegex(String pattern) {
        RegexParser parser = new RegexParser(pattern, new RegexParserOption[0]);
        RegexNode root = parser.parse();
        return root.accept(new GlushkovNormalizer());
    }

    @Override
    public GlushkovPrefixExtender forFactor(String prefix) {
        BitSet prefixInitial = this.match(this.automaton.getInitial(), new StringCharProvider(prefix, 0), new MatchListener[0]);
        return new GlushkovPrefixExtender(this.pattern, this.automaton, this.minLength, prefix.length(), prefixInitial);
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public int getPatternLength() {
        return this.minLength;
    }

    @Override
    public List<String> getBestFactors(int max) {
        return new ArrayList<String>(this.getPrefixes(max));
    }

    @Override
    public boolean hasFactor(String factor) {
        return this.getPrefixes(factor.length()).contains(factor);
    }

    public Set<String> getPrefixes(int max) {
        return this.getPrefixes(this.automaton.getInitial(), 1, max);
    }

    private Set<String> getPrefixes(BitSet state, int min, int max) {
        LinkedHashSet<String> prefixes = new LinkedHashSet<String>();
        if (min <= 0 && this.automaton.isFinal(state)) {
            prefixes.add("");
            return prefixes;
        }
        if (max <= 0) {
            prefixes.add("");
            return prefixes;
        }
        for (char c : this.automaton.supportedChars()) {
            BitSet next = this.automaton.next(state, c);
            if (next.isEmpty()) continue;
            Set<String> subPrefixes = this.getPrefixes(next, min - 1, max - 1);
            for (String subPrefix : subPrefixes) {
                prefixes.add(c + subPrefix);
            }
        }
        return prefixes;
    }

    @Override
    public SortedSet<StringMatch> extendFactor(CharProvider chars, boolean longest) {
        MatchBuilder listener = new MatchBuilder(longest);
        this.match(this.prefixInitial, chars, listener);
        return listener.getMatches();
    }

    private BitSet match(BitSet state, CharProvider chars, MatchListener ... listeners) {
        boolean notify = listeners != null && listeners.length > 0;
        long pos = chars.current();
        long start = pos - (long)this.prefixLength;
        while (!chars.finished() && !state.isEmpty()) {
            if (notify && this.automaton.isFinal(state)) {
                long end = chars.current();
                for (MatchListener listener : listeners) {
                    listener.notify(start, end, chars);
                }
            }
            char c = chars.next();
            state = this.automaton.next(state, c);
        }
        if (notify && chars.finished() && this.automaton.isFinal(state)) {
            long end = chars.current();
            for (MatchListener listener : listeners) {
                listener.notify(start, end, chars);
            }
        }
        chars.move(pos);
        return state;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Factory
    implements FactorExtenderFactory {
        @Override
        public FactorExtender of(String pattern) {
            return new GlushkovPrefixExtender(pattern);
        }
    }
}

