/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.regexparser;

import net.amygdalum.regexparser.RegexNode;
import net.amygdalum.regexparser.RegexNodeVisitor;

public class UnboundedLoopNode
implements RegexNode {
    private RegexNode subNode;
    private int from;

    private UnboundedLoopNode(RegexNode subNode, int from) {
        this.subNode = subNode;
        this.from = from;
    }

    public static UnboundedLoopNode star(RegexNode node) {
        return new UnboundedLoopNode(node, 0);
    }

    public static UnboundedLoopNode plus(RegexNode node) {
        return new UnboundedLoopNode(node, 1);
    }

    public static UnboundedLoopNode unbounded(RegexNode node, int from) {
        return new UnboundedLoopNode(node, from);
    }

    public int getFrom() {
        return this.from;
    }

    public RegexNode getSubNode() {
        return this.subNode;
    }

    @Override
    public <T> T accept(RegexNodeVisitor<T> visitor) {
        return visitor.visitUnboundedLoop(this);
    }

    @Override
    public UnboundedLoopNode clone() {
        try {
            UnboundedLoopNode clone = (UnboundedLoopNode)super.clone();
            clone.subNode = this.subNode.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.subNode);
        if (this.from == 0) {
            buffer.append('*');
        } else if (this.from == 1) {
            buffer.append('+');
        } else {
            buffer.append('{');
            buffer.append(this.from);
            buffer.append(',');
            buffer.append('}');
        }
        return buffer.toString();
    }
}

