/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.regexparser;

import java.util.ArrayList;
import java.util.List;
import net.amygdalum.regexparser.CharNode;
import net.amygdalum.regexparser.JoinableNode;
import net.amygdalum.regexparser.RegexNode;
import net.amygdalum.regexparser.RegexNodeVisitor;
import net.amygdalum.regexparser.SingleCharNode;

public class StringNode
implements RegexNode,
JoinableNode {
    private String value;

    public StringNode(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public String getLiteralValue() {
        return this.value;
    }

    public List<CharNode> toCharNodes() {
        ArrayList<CharNode> charNodes = new ArrayList<CharNode>(this.value.length());
        for (char c : this.value.toCharArray()) {
            charNodes.add(new SingleCharNode(c));
        }
        return charNodes;
    }

    @Override
    public <T> T accept(RegexNodeVisitor<T> visitor) {
        return visitor.visitString(this);
    }

    @Override
    public StringNode clone() {
        try {
            return (StringNode)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String toString() {
        return this.value;
    }
}

