/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.regexparser;

import net.amygdalum.regexparser.DefinedCharNode;
import net.amygdalum.regexparser.RegexNodeVisitor;
import net.amygdalum.regexparser.SingleCharNode;
import net.amygdalum.util.text.CharUtils;

public class RangeCharNode
extends DefinedCharNode {
    private char from;
    private char to;

    public RangeCharNode(char from, char to) {
        this.from = from;
        this.to = to;
    }

    @Override
    public char getFrom() {
        return this.from;
    }

    @Override
    public char getTo() {
        return this.to;
    }

    public DefinedCharNode simplify() {
        if (this.from == this.to) {
            return new SingleCharNode(this.from);
        }
        return this;
    }

    @Override
    public <T> T accept(RegexNodeVisitor<T> visitor) {
        return visitor.visitRangeChar(this);
    }

    @Override
    public RangeCharNode clone() {
        return (RangeCharNode)super.clone();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        buffer.append(this.toInlinedString());
        buffer.append(']');
        return buffer.toString();
    }

    @Override
    public String toInlinedString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(CharUtils.charToString((char)this.from));
        buffer.append('-');
        buffer.append(CharUtils.charToString((char)this.to));
        return buffer.toString();
    }
}

