/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.regexparser;

import java.util.Arrays;
import java.util.List;
import net.amygdalum.regexparser.AbstractCharClassNode;
import net.amygdalum.regexparser.CompClassNode;
import net.amygdalum.regexparser.DefinedCharNode;
import net.amygdalum.regexparser.RegexNode;
import net.amygdalum.regexparser.RegexNodeVisitor;

public class CharClassNode
extends AbstractCharClassNode
implements RegexNode {
    private List<DefinedCharNode> charNodes;

    public CharClassNode(DefinedCharNode ... charNodes) {
        this(Arrays.asList(charNodes));
    }

    public CharClassNode(List<DefinedCharNode> charNodes) {
        this.charNodes = charNodes;
    }

    @Override
    public List<DefinedCharNode> toCharNodes() {
        return this.charNodes;
    }

    @Override
    public CompClassNode invert(List<DefinedCharNode> allNodes) {
        return new CompClassNode(this.charNodes, CharClassNode.computeComplement(this.charNodes, allNodes));
    }

    @Override
    public <T> T accept(RegexNodeVisitor<T> visitor) {
        return visitor.visitCharClass(this);
    }

    @Override
    public CharClassNode clone() {
        return (CharClassNode)super.clone();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('[');
        for (DefinedCharNode next : this.charNodes) {
            buffer.append(next.toInlinedString());
        }
        buffer.append(']');
        return buffer.toString();
    }
}

