/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.regexparser;

import net.amygdalum.regexparser.RegexNode;
import net.amygdalum.regexparser.RegexNodeVisitor;

public class BoundedLoopNode
implements RegexNode {
    private RegexNode subNode;
    private int from;
    private int to;

    private BoundedLoopNode(RegexNode subNode, int from, int to) {
        this.subNode = subNode;
        this.from = from;
        this.to = to;
    }

    public static BoundedLoopNode bounded(RegexNode node, int from, int to) {
        return new BoundedLoopNode(node, from, to);
    }

    public int getFrom() {
        return this.from;
    }

    public int getTo() {
        return this.to;
    }

    public RegexNode getSubNode() {
        return this.subNode;
    }

    @Override
    public <T> T accept(RegexNodeVisitor<T> visitor) {
        return visitor.visitBoundedLoop(this);
    }

    @Override
    public BoundedLoopNode clone() {
        try {
            BoundedLoopNode clone = (BoundedLoopNode)super.clone();
            clone.subNode = this.subNode.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.subNode);
        buffer.append('{');
        buffer.append(this.from);
        if (this.to != this.from) {
            buffer.append(',');
            buffer.append(this.to);
        }
        buffer.append('}');
        return buffer.toString();
    }
}

