/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.patternsearchalgorithms.pattern.chars;

import java.util.Arrays;
import net.amygdalum.patternsearchalgorithms.automaton.chars.DFA;
import net.amygdalum.patternsearchalgorithms.automaton.chars.MinimalNFAComponentFactory;
import net.amygdalum.patternsearchalgorithms.automaton.chars.NFA;
import net.amygdalum.patternsearchalgorithms.automaton.chars.NFABuilder;
import net.amygdalum.patternsearchalgorithms.automaton.chars.NFAComponent;
import net.amygdalum.patternsearchalgorithms.pattern.Matcher;
import net.amygdalum.patternsearchalgorithms.pattern.SearchMode;
import net.amygdalum.patternsearchalgorithms.pattern.chars.MatcherFactory;
import net.amygdalum.patternsearchalgorithms.pattern.chars.SearchAllNonOverlappingMatcher;
import net.amygdalum.patternsearchalgorithms.pattern.chars.SearchAllOverlappingMatcher;
import net.amygdalum.patternsearchalgorithms.pattern.chars.SearchLongestNonOverlappingMatcher;
import net.amygdalum.patternsearchalgorithms.pattern.chars.SearchLongestOverlappingMatcher;
import net.amygdalum.regexparser.RegexNode;
import net.amygdalum.regexparser.RegexNodeVisitor;
import net.amygdalum.util.io.CharProvider;

public class SearchMatcherFactory
implements MatcherFactory {
    private SearchMode mode;
    private DFA finder;
    private DFA backmatcher;
    private NFA grouper;

    public SearchMatcherFactory(SearchMode mode) {
        this.mode = mode;
    }

    public static SearchMatcherFactory compile(RegexNode node, SearchMode mode) {
        return new SearchMatcherFactory(mode).compile(node);
    }

    private SearchMatcherFactory compile(RegexNode node) {
        this.finder = this.finderFrom(node);
        this.backmatcher = this.backmatcherFrom(node);
        this.grouper = this.grouperFrom(node);
        return this;
    }

    private DFA finderFrom(RegexNode node) {
        NFABuilder builder = new NFABuilder(new MinimalNFAComponentFactory());
        NFAComponent base = (NFAComponent)node.accept((RegexNodeVisitor)builder);
        NFAComponent selfloop = builder.matchStarLoop(builder.match('\u0000', '\uffff')).silent();
        NFAComponent finder = builder.matchConcatenation(Arrays.asList(selfloop, base));
        NFA nfa = builder.build(finder);
        return DFA.from(nfa);
    }

    private DFA backmatcherFrom(RegexNode node) {
        NFABuilder builder = new NFABuilder(new MinimalNFAComponentFactory());
        NFAComponent base = (NFAComponent)node.accept((RegexNodeVisitor)builder);
        NFAComponent reverse = base.reverse();
        NFA nfa = builder.build(reverse);
        return DFA.from(nfa);
    }

    private NFA grouperFrom(RegexNode node) {
        NFABuilder builder = new NFABuilder();
        NFAComponent base = builder.matchGroup((NFAComponent)node.accept((RegexNodeVisitor)builder), 0);
        NFA grouper = builder.build(base);
        grouper.prune();
        return grouper;
    }

    @Override
    public Matcher newMatcher(CharProvider input) {
        if (this.mode.findLongest()) {
            if (this.mode.findOverlapping()) {
                return new SearchLongestOverlappingMatcher(this.finder, this.backmatcher, this.grouper, input);
            }
            return new SearchLongestNonOverlappingMatcher(this.finder, this.backmatcher, this.grouper, input);
        }
        if (this.mode.findOverlapping()) {
            return new SearchAllOverlappingMatcher(this.finder, this.backmatcher, this.grouper, input);
        }
        return new SearchAllNonOverlappingMatcher(this.finder, this.backmatcher, this.grouper, input);
    }
}

