/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.patternsearchalgorithms.pattern.bytes;

import net.amygdalum.patternsearchalgorithms.automaton.bytes.DFA;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.Groups;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.NFA;
import net.amygdalum.patternsearchalgorithms.pattern.Matcher;
import net.amygdalum.util.io.ByteProvider;

public class SimpleAllNonOverlappingMatcher
implements Matcher {
    private DFA matcher;
    private NFA grouper;
    private ByteProvider input;
    private final long start;
    private Groups groups;
    private int nextstate;

    public SimpleAllNonOverlappingMatcher(DFA matcher, NFA grouper, ByteProvider input) {
        this.matcher = matcher;
        this.grouper = grouper;
        this.input = input;
        this.start = input.current();
        this.groups = new Groups();
        this.nextstate = -1;
    }

    @Override
    public boolean matches() {
        int state = this.matcher.start;
        while (!this.input.finished() && state >= 0) {
            byte b = this.input.next();
            state = this.matcher.next(state, b);
        }
        if (this.matcher.accept(state)) {
            this.groups.update(this.start, this.input.current());
            this.input.move(this.start);
            return true;
        }
        this.input.move(this.start);
        return false;
    }

    @Override
    public boolean prefixes() {
        int state = this.matcher.start;
        if (this.matcher.accept(state)) {
            this.groups.update(this.start, this.input.current());
            this.input.move(this.start);
            return true;
        }
        while (!this.input.finished() && state >= 0) {
            byte b = this.input.next();
            if (!this.matcher.accept(state = this.matcher.next(state, b))) continue;
            this.groups.update(this.start, this.input.current());
            this.input.move(this.start);
            return true;
        }
        if (this.matcher.accept(state)) {
            this.groups.update(this.start, this.input.current());
            this.input.move(this.start);
            return true;
        }
        this.input.move(this.start);
        return false;
    }

    @Override
    public boolean find() {
        int state = this.matcher.start;
        long localstart = this.input.current();
        if (this.nextstate >= 0) {
            this.groups.reset();
            state = this.nextstate;
            this.nextstate = -1;
        } else {
            if (this.matcher.accept(state)) {
                this.groups.update(this.start, this.input.current());
                this.nextstate = state;
                this.input.move(this.groups.getEnd());
                return true;
            }
            this.groups.reset();
        }
        while (!this.input.finished() && state >= 0) {
            byte b = this.input.next();
            if (this.matcher.accept(state = this.matcher.next(state, b))) {
                this.groups.update(localstart, this.input.current());
                this.input.move(this.groups.getEnd());
                return true;
            }
            if (state != -1) continue;
            this.input.move(++localstart);
            state = this.matcher.start;
            if (!this.matcher.accept(state)) continue;
            this.groups.update(localstart, localstart);
            this.nextstate = state;
            return true;
        }
        if (this.matcher.accept(state)) {
            this.groups.update(localstart, this.input.current());
            return true;
        }
        return false;
    }

    @Override
    public long start() {
        return this.groups.getStart();
    }

    @Override
    public long start(int no) {
        if (!this.groups.isComplete()) {
            this.groups.process(this.input, this.grouper);
        }
        return this.groups.getStart(no);
    }

    @Override
    public long end() {
        return this.groups.getEnd();
    }

    @Override
    public long end(int no) {
        if (!this.groups.isComplete()) {
            this.groups.process(this.input, this.grouper);
        }
        return this.groups.getEnd(no);
    }

    @Override
    public String group() {
        long start = this.groups.getStart();
        long end = this.groups.getEnd();
        if (start != -1L && end != -1L && start <= end) {
            return this.input.slice(start, end).getString();
        }
        return null;
    }

    @Override
    public String group(int no) {
        if (!this.groups.isComplete()) {
            this.groups.process(this.input, this.grouper);
        }
        long start = this.groups.getStart(no);
        long end = this.groups.getEnd(no);
        if (start != -1L && end != -1L && start <= end) {
            return this.input.slice(start, end).getString();
        }
        return null;
    }
}

