/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.patternsearchalgorithms.automaton.chars;

import java.util.ArrayList;
import java.util.List;
import net.amygdalum.patternsearchalgorithms.automaton.chars.Transition;

public class State
implements Cloneable,
Comparable<State> {
    private int id = System.identityHashCode(this);
    private List<Transition> out;
    private List<Transition> in;
    private boolean accept;
    private boolean silent;

    public State() {
        this.out = new ArrayList<Transition>();
        this.in = new ArrayList<Transition>();
    }

    public State(int transitionCount) {
        this.out = new ArrayList<Transition>(transitionCount);
        this.in = new ArrayList<Transition>();
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public void setAccepting() {
        this.accept = true;
    }

    public void setAccepting(boolean accept) {
        this.accept = accept;
    }

    public boolean isAccepting() {
        return this.accept;
    }

    public void setSilent() {
        this.silent = true;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public State asPrototype() {
        return new State(this.out.size());
    }

    void addOut(Transition transition) {
        this.out.add(transition);
    }

    void removeOut(Transition transition) {
        this.out.remove(transition);
    }

    public List<Transition> out() {
        return this.out;
    }

    void addIn(Transition transition) {
        this.in.add(transition);
    }

    void removeIn(Transition transition) {
        this.in.remove(transition);
    }

    public List<Transition> in() {
        return this.in;
    }

    public void disconnect() {
        List<Transition> inOld = this.in;
        this.in = new ArrayList<Transition>();
        for (Transition t : inOld) {
            t.remove();
        }
        List<Transition> outOld = this.out;
        this.out = new ArrayList<Transition>();
        for (Transition t : outOld) {
            t.remove();
        }
    }

    @Override
    public int compareTo(State that) {
        return Integer.compare(this.id, that.id);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getId()).append(" {\n");
        for (Transition transition : this.out) {
            buffer.append(transition.toString()).append('\n');
        }
        buffer.append('}');
        return buffer.toString();
    }
}

