/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.patternsearchalgorithms.automaton.chars;

import net.amygdalum.patternsearchalgorithms.automaton.chars.Action;
import net.amygdalum.patternsearchalgorithms.automaton.chars.State;
import net.amygdalum.patternsearchalgorithms.automaton.chars.StateClone;
import net.amygdalum.patternsearchalgorithms.automaton.chars.Transition;
import net.amygdalum.util.worklist.WorkSet;

public class NFAComponent
implements Cloneable {
    public State start;
    public State end;

    public NFAComponent(State start, State end) {
        this.start = start;
        this.end = end;
    }

    public NFAComponent reverse() {
        WorkSet todo = new WorkSet();
        todo.addAll(this.start.out());
        while (!todo.isEmpty()) {
            Transition current = (Transition)todo.remove();
            State target = current.getTarget();
            todo.addAll(target.out());
        }
        for (Transition transition : todo.getDone()) {
            State origin = transition.getOrigin();
            State target = transition.getTarget();
            Action action = transition.getAction();
            transition.remove();
            transition.asPrototype().withOrigin(target).withTarget(origin).withAction(action).connect();
        }
        return new NFAComponent(this.end, this.start);
    }

    public NFAComponent silent() {
        WorkSet todo = new WorkSet();
        todo.add((Object)this.start);
        while (!todo.isEmpty()) {
            State current = (State)todo.remove();
            current.setSilent();
        }
        return this;
    }

    protected NFAComponent clone() {
        try {
            NFAComponent clone = (NFAComponent)super.clone();
            StateClone statClone = StateClone.cloneTree(this.start);
            clone.start = statClone.get(this.start);
            clone.end = statClone.get(this.end);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

