/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.patternsearchalgorithms.automaton.chars;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import net.amygdalum.patternsearchalgorithms.automaton.chars.CharTransition;
import net.amygdalum.patternsearchalgorithms.automaton.chars.CharsTransition;
import net.amygdalum.patternsearchalgorithms.automaton.chars.EndGroup;
import net.amygdalum.patternsearchalgorithms.automaton.chars.EpsilonTransition;
import net.amygdalum.patternsearchalgorithms.automaton.chars.NFA;
import net.amygdalum.patternsearchalgorithms.automaton.chars.NFAComponent;
import net.amygdalum.patternsearchalgorithms.automaton.chars.NFAComponentFactory;
import net.amygdalum.patternsearchalgorithms.automaton.chars.SimpleNFAComponentFactory;
import net.amygdalum.patternsearchalgorithms.automaton.chars.StartGroup;
import net.amygdalum.patternsearchalgorithms.automaton.chars.State;
import net.amygdalum.regexparser.AlternativesNode;
import net.amygdalum.regexparser.AnyCharNode;
import net.amygdalum.regexparser.BoundedLoopNode;
import net.amygdalum.regexparser.CharClassNode;
import net.amygdalum.regexparser.CompClassNode;
import net.amygdalum.regexparser.ConcatNode;
import net.amygdalum.regexparser.EmptyNode;
import net.amygdalum.regexparser.GroupNode;
import net.amygdalum.regexparser.OptionalNode;
import net.amygdalum.regexparser.RangeCharNode;
import net.amygdalum.regexparser.RegexNode;
import net.amygdalum.regexparser.RegexNodeVisitor;
import net.amygdalum.regexparser.SingleCharNode;
import net.amygdalum.regexparser.SpecialCharClassNode;
import net.amygdalum.regexparser.StringNode;
import net.amygdalum.regexparser.UnboundedLoopNode;

public class NFABuilder
implements RegexNodeVisitor<NFAComponent> {
    private NFAComponentFactory factory;
    private int groupIndex;

    public NFABuilder() {
        this(new SimpleNFAComponentFactory());
    }

    public NFABuilder(NFAComponentFactory factory) {
        this.factory = factory;
        this.groupIndex = 0;
    }

    private int nextGroupIndex() {
        ++this.groupIndex;
        return this.groupIndex;
    }

    public NFAComponent match(char value) {
        State s = new State();
        State e = new State();
        this.connect(s, e, value);
        return this.factory.create(s, e);
    }

    public NFAComponent match(String value) {
        State s = new State();
        State e = new State();
        this.connect(s, e, value);
        return this.factory.create(s, e);
    }

    public NFAComponent match(char from, char to) {
        State s = new State();
        State e = new State();
        if (from > to) {
            char temp = from;
            from = to;
            to = temp;
        }
        this.connect(s, e, from, to);
        return this.factory.create(s, e);
    }

    private void connect(State s, State e, String value) {
        int i;
        char[] chars = value.toCharArray();
        State[] states = new State[chars.length + 1];
        states[0] = s;
        for (i = 1; i < chars.length; ++i) {
            states[i] = new State();
        }
        states[chars.length] = e;
        for (i = 0; i < chars.length; ++i) {
            char c = chars[i];
            State state = states[i];
            State target = states[i + 1];
            new CharTransition(state, c, target).connect();
        }
    }

    private void connect(State s, State e, char value) {
        new CharTransition(s, value, e).connect();
    }

    private void connect(State s, State e, char from, char to) {
        new CharsTransition(s, from, to, e).connect();
    }

    public NFAComponent matchGroup(NFAComponent a, int no) {
        State s = new State();
        State e = new State();
        new EpsilonTransition(s, a.start).withAction(new StartGroup(no)).connect();
        new EpsilonTransition(a.end, e).withAction(new EndGroup(no)).connect();
        return this.factory.create(s, e);
    }

    public NFAComponent matchAlternatives(List<NFAComponent> as) {
        if (as.size() == 1) {
            return as.get(0);
        }
        State s = new State();
        State e = new State();
        for (NFAComponent a : as) {
            State n = a.start;
            new EpsilonTransition(s, n).connect();
            new EpsilonTransition(a.end, e).connect();
        }
        return this.factory.create(s, e);
    }

    public NFAComponent matchConcatenation(List<NFAComponent> as) {
        if (as.size() == 1) {
            return as.get(0);
        }
        State s = as.get((int)0).start;
        State e = as.get((int)(as.size() - 1)).end;
        State last = null;
        ListIterator<NFAComponent> aIterator = as.listIterator();
        while (aIterator.hasNext()) {
            NFAComponent a = aIterator.next();
            if (last != null) {
                new EpsilonTransition(last, a.start).connect();
            }
            last = a.end;
        }
        return this.factory.create(s, e);
    }

    public NFAComponent matchEmpty() {
        State s = new State();
        return this.factory.create(s, s);
    }

    public NFAComponent matchNothing() {
        State s = new State();
        return this.factory.create(s, null);
    }

    public NFAComponent matchOptional(NFAComponent a) {
        State s = new State();
        State e = new State();
        new EpsilonTransition(s, e).connect();
        new EpsilonTransition(s, a.start).connect();
        new EpsilonTransition(a.end, e).connect();
        return this.factory.create(s, e);
    }

    public NFAComponent matchUnlimitedLoop(NFAComponent a, int start) {
        if (start == 0) {
            return this.matchStarLoop(a);
        }
        ArrayList<NFAComponent> as = new ArrayList<NFAComponent>();
        as.addAll(NFABuilder.copyOf(a.clone(), start));
        as.add(this.matchStarLoop(a));
        return this.matchConcatenation(as);
    }

    public NFAComponent matchStarLoop(NFAComponent a) {
        State s = new State();
        State e = new State();
        new EpsilonTransition(s, a.start).connect();
        new EpsilonTransition(s, e).connect();
        new EpsilonTransition(a.end, a.start).connect();
        new EpsilonTransition(a.end, e).connect();
        return this.factory.create(s, e);
    }

    public NFAComponent matchRangeLoop(NFAComponent a, int start, int end) {
        if (start == end) {
            return this.matchFixedLoop(a, start);
        }
        if (start == 0) {
            return this.matchUpToN(a, end);
        }
        NFAComponent aFixed = this.matchFixedLoop(a.clone(), start);
        NFAComponent aUpToN = this.matchUpToN(a, end - start);
        NFAComponent matchConcatenation = this.matchConcatenation(Arrays.asList(aFixed, aUpToN));
        return matchConcatenation;
    }

    public NFAComponent matchFixedLoop(NFAComponent a, int count) {
        List<NFAComponent> as = NFABuilder.copyOf(a, count);
        return this.matchConcatenation(as);
    }

    public NFAComponent matchUpToN(NFAComponent a, int count) {
        State s = new State();
        State e = new State();
        new EpsilonTransition(s, e).connect();
        State current = s;
        for (int i = 0; i < count; ++i) {
            NFAComponent ai = a.clone();
            new EpsilonTransition(current, ai.start).connect();
            new EpsilonTransition(ai.end, e).connect();
            current = ai.end;
        }
        return this.factory.create(s, e);
    }

    private static List<NFAComponent> copyOf(NFAComponent a, int count) {
        ArrayList<NFAComponent> copies = new ArrayList<NFAComponent>(count);
        copies.add(a);
        for (int i = 1; i < count; ++i) {
            copies.add(a.clone());
        }
        return copies;
    }

    public NFAComponent visitAlternatives(AlternativesNode node) {
        List<NFAComponent> as = this.accept(node.getSubNodes());
        return this.matchAlternatives(as);
    }

    public NFAComponent visitAnyChar(AnyCharNode node) {
        List<NFAComponent> as = this.accept(node.toCharNodes());
        return this.matchAlternatives(as);
    }

    public NFAComponent visitCharClass(CharClassNode node) {
        List<NFAComponent> as = this.accept(node.toCharNodes());
        return this.matchAlternatives(as);
    }

    public NFAComponent visitCompClass(CompClassNode node) {
        List<NFAComponent> as = this.accept(node.toCharNodes());
        return this.matchAlternatives(as);
    }

    public NFAComponent visitConcat(ConcatNode node) {
        List<NFAComponent> as = this.accept(node.getSubNodes());
        return this.matchConcatenation(as);
    }

    public NFAComponent visitEmpty(EmptyNode node) {
        return this.matchEmpty();
    }

    public NFAComponent visitGroup(GroupNode node) {
        int no = this.nextGroupIndex();
        NFAComponent a = (NFAComponent)node.getSubNode().accept((RegexNodeVisitor)this);
        return this.matchGroup(a, no);
    }

    public NFAComponent visitBoundedLoop(BoundedLoopNode node) {
        NFAComponent a = (NFAComponent)node.getSubNode().accept((RegexNodeVisitor)this);
        int from = node.getFrom();
        int to = node.getTo();
        return this.matchRangeLoop(a, from, to);
    }

    public NFAComponent visitUnboundedLoop(UnboundedLoopNode node) {
        NFAComponent a = (NFAComponent)node.getSubNode().accept((RegexNodeVisitor)this);
        int from = node.getFrom();
        return this.matchUnlimitedLoop(a, from);
    }

    public NFAComponent visitOptional(OptionalNode node) {
        NFAComponent a = (NFAComponent)node.getSubNode().accept((RegexNodeVisitor)this);
        return this.matchOptional(a);
    }

    public NFAComponent visitRangeChar(RangeCharNode node) {
        return this.match(node.getFrom(), node.getTo());
    }

    public NFAComponent visitSingleChar(SingleCharNode node) {
        return this.match(node.getValue());
    }

    public NFAComponent visitSpecialCharClass(SpecialCharClassNode node) {
        List<NFAComponent> as = this.accept(node.toCharNodes());
        return this.matchAlternatives(as);
    }

    public NFAComponent visitString(StringNode node) {
        return this.match(node.getValue());
    }

    private List<NFAComponent> accept(List<? extends RegexNode> nodes) {
        ArrayList<NFAComponent> as = new ArrayList<NFAComponent>(nodes.size());
        for (RegexNode regexNode : nodes) {
            as.add((NFAComponent)regexNode.accept((RegexNodeVisitor)this));
        }
        return as;
    }

    public NFA build(RegexNode node) {
        NFAComponent nfa = (NFAComponent)node.accept((RegexNodeVisitor)this);
        return this.build(nfa);
    }

    public NFA build(NFAComponent nfa) {
        State start = nfa.start;
        State end = nfa.end;
        if (end != null) {
            end.setAccepting();
        }
        return new NFA(start);
    }
}

