/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.patternsearchalgorithms.automaton.chars;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.TreeSet;
import net.amygdalum.patternsearchalgorithms.automaton.chars.Action;
import net.amygdalum.patternsearchalgorithms.automaton.chars.CharTransition;
import net.amygdalum.patternsearchalgorithms.automaton.chars.CharsTransition;
import net.amygdalum.patternsearchalgorithms.automaton.chars.EpsilonTransition;
import net.amygdalum.patternsearchalgorithms.automaton.chars.OrdinaryTransition;
import net.amygdalum.patternsearchalgorithms.automaton.chars.State;
import net.amygdalum.patternsearchalgorithms.automaton.chars.StateClone;
import net.amygdalum.patternsearchalgorithms.automaton.chars.Transition;
import net.amygdalum.patternsearchalgorithms.automaton.chars.TransitionComparator;
import net.amygdalum.util.text.CharRange;
import net.amygdalum.util.text.CharRangeAccumulator;
import net.amygdalum.util.worklist.WorkSet;

public class NFA
implements Cloneable {
    private State start;
    private List<CharRange> charRanges;
    private State[] states;
    private int accepting;

    public NFA(State start) {
        this.init(start);
    }

    private void init(State start) {
        this.start = start;
        this.charRanges = NFA.computeEquivalentCharRanges(start);
        this.states = NFA.clean(start, null);
        this.accepting = NFA.order(this.states);
    }

    private void init(State start, State error) {
        this.start = start;
        this.charRanges = NFA.computeEquivalentCharRanges(start);
        this.states = NFA.clean(start, error);
        this.accepting = NFA.order(this.states);
    }

    public State getStart() {
        return this.start;
    }

    public State[] states() {
        return this.states;
    }

    public State[] accepting() {
        return Arrays.copyOfRange(this.states, this.accepting, this.states.length);
    }

    public List<CharRange> getCharRanges() {
        return this.charRanges;
    }

    private static State[] clean(State start, State error) {
        WorkSet todo = new WorkSet();
        todo.add((Object)start);
        HashSet<State> dead = new HashSet<State>();
        WorkSet live = new WorkSet();
        while (!todo.isEmpty()) {
            State state = (State)todo.remove();
            if (state.isAccepting()) {
                live.add((Object)state);
            } else {
                dead.add(state);
            }
            for (Transition transition : state.out()) {
                todo.add((Object)transition.getTarget());
            }
        }
        while (!live.isEmpty()) {
            State current = (State)live.remove();
            for (Transition liveTransition : current.in()) {
                State nextLive = liveTransition.getOrigin();
                live.add((Object)nextLive);
                dead.remove(nextLive);
            }
        }
        dead.remove(start);
        live.remove((Object)start);
        live.getDone().add(start);
        if (error != null) {
            dead.remove(error);
            live.remove((Object)error);
            live.getDone().add(error);
        }
        for (State current : dead) {
            current.disconnect();
        }
        return live.getDone().toArray(new State[0]);
    }

    private static int order(State[] states) {
        int left = 0;
        int right = states.length - 1;
        while (left <= right) {
            while (left < states.length && !states[left].isAccepting()) {
                states[left].setId(left);
                ++left;
            }
            while (right >= 0 && states[right].isAccepting()) {
                states[right].setId(right);
                --right;
            }
            if (left >= right) continue;
            State temp = states[right];
            states[right] = states[left];
            states[left] = temp;
        }
        return right + 1;
    }

    public void prune() {
        this.eliminateTrivialEpsilons();
        this.mergeTransitions();
    }

    public void determinize() {
        this.eliminateAllEpsilons();
        this.mergeTransitions();
        this.determinizeStates();
        this.totalizeStates();
        this.minimizeStates();
    }

    private void totalizeStates() {
        State error = new State();
        WorkSet todo = new WorkSet();
        todo.add(error);
        todo.add(this.start);
        while (!todo.isEmpty()) {
            State current = (State)todo.remove();
            LinkedList<CharRange> missingRanges = new LinkedList<CharRange>(this.charRanges);
            block1: for (Transition transition : current.out()) {
                todo.add(transition.getTarget());
                if (!(transition instanceof OrdinaryTransition)) continue;
                char c = ((OrdinaryTransition)transition).getFrom();
                Iterator iterator = missingRanges.iterator();
                while (iterator.hasNext()) {
                    CharRange check = (CharRange)iterator.next();
                    if (!check.contains(c)) continue;
                    iterator.remove();
                    continue block1;
                }
            }
            for (CharRange range : missingRanges) {
                new CharsTransition(current, range.from, range.to, error).connect();
            }
        }
        this.init(this.start, error);
    }

    private void minimizeStates() {
        LinkedList<Set<State>> partitions = new LinkedList<Set<State>>();
        LinkedList<Set<State>> todo = new LinkedList<Set<State>>();
        SplitPartition initialPartition = this.initialPartition();
        if (initialPartition.min.isEmpty()) {
            partitions.add(initialPartition.max);
        } else {
            partitions.add(initialPartition.max);
            partitions.add(initialPartition.min);
            todo.add(initialPartition.min);
        }
        while (!todo.isEmpty()) {
            Set current = (Set)todo.remove();
            for (CharRange charRange : this.charRanges) {
                Set<State> origins = this.origins(current, charRange);
                ListIterator<Set<State>> partitionIterator = partitions.listIterator();
                while (partitionIterator.hasNext()) {
                    Set partition = (Set)partitionIterator.next();
                    SplitPartition splitPartition = this.split(partition, origins);
                    if (splitPartition.min.isEmpty()) continue;
                    partitionIterator.set(splitPartition.max);
                    partitionIterator.add(splitPartition.min);
                    if (todo.contains(partition)) {
                        todo.remove(partition);
                        todo.add(splitPartition.max);
                        todo.add(splitPartition.min);
                        continue;
                    }
                    todo.add(splitPartition.min);
                }
            }
        }
        State newstart = this.digest(partitions);
        this.init(newstart);
    }

    private State digest(List<Set<State>> partitions) {
        IdentityHashMap<State, State> mapping = new IdentityHashMap<State, State>();
        State start = null;
        for (Set<State> partition : partitions) {
            State state = new State();
            for (State partstate : partition) {
                mapping.put(partstate, state);
                if (partstate.isAccepting()) {
                    state.setAccepting();
                }
                if (!partstate.isSilent()) {
                    state.setSilent(false);
                }
                if (partstate != this.start) continue;
                start = state;
            }
        }
        for (Set<State> partition : partitions) {
            State representative = partition.iterator().next();
            for (Transition transition : representative.out()) {
                State origin = transition.getOrigin();
                State mappedOrigin = (State)mapping.get(origin);
                State target = transition.getTarget();
                State mappedTarget = (State)mapping.get(target);
                transition.asPrototype().withOrigin(mappedOrigin).withTarget(mappedTarget).connect();
            }
        }
        return start;
    }

    private SplitPartition split(Set<State> partition, Set<State> splitter) {
        HashSet<State> intersection = new HashSet<State>(partition.size());
        HashSet<State> remainder = new HashSet<State>(partition.size());
        for (State state : partition) {
            if (splitter.contains(state)) {
                intersection.add(state);
                continue;
            }
            remainder.add(state);
        }
        return new SplitPartition(intersection, remainder);
    }

    private Set<State> origins(Set<State> states, CharRange charRange) {
        HashSet<State> in = new HashSet<State>();
        for (State state : states) {
            for (Transition transition : state.in()) {
                if (!(transition instanceof OrdinaryTransition) || !((OrdinaryTransition)transition).accepts(charRange.from)) continue;
                in.add(transition.getOrigin());
            }
        }
        return in;
    }

    private SplitPartition initialPartition() {
        HashSet<State> accept = new HashSet<State>(this.states.length);
        HashSet<State> nonaccept = new HashSet<State>(this.states.length);
        for (State state : this.states) {
            if (state.isAccepting()) {
                accept.add(state);
                continue;
            }
            nonaccept.add(state);
        }
        return new SplitPartition(accept, nonaccept);
    }

    private void determinizeStates() {
        HashMap dStates = new HashMap();
        WorkSet todo = new WorkSet();
        HashSet<State> startset = new HashSet<State>();
        startset.add(this.start);
        todo.add(startset);
        State dStart = new State();
        dStates.put(startset, dStart);
        while (!todo.isEmpty()) {
            Set current = (Set)todo.remove();
            State dState = (State)dStates.get(current);
            this.transferAccept(current, dState);
            for (CharRange range : this.charRanges) {
                char from = range.from;
                char to = range.to;
                HashSet<State> nextset = new HashSet<State>();
                for (State state : current) {
                    for (Transition transition : state.out()) {
                        if (!(transition instanceof OrdinaryTransition) || !((OrdinaryTransition)transition).accepts(from)) continue;
                        nextset.add(transition.getTarget());
                    }
                }
                State target = (State)dStates.get(nextset);
                if (target == null) {
                    todo.add(nextset);
                    target = new State();
                    dStates.put(nextset, target);
                }
                if (from == to) {
                    new CharTransition(dState, from, target).connect();
                    continue;
                }
                new CharsTransition(dState, from, to, target).connect();
            }
        }
        this.init(dStart);
    }

    private void transferAccept(Set<State> states, State dState) {
        boolean accepting = false;
        boolean silent = true;
        for (State state : states) {
            accepting |= state.isAccepting();
            silent &= state.isSilent();
        }
        dState.setAccepting(accepting);
        dState.setSilent(silent);
    }

    private static List<CharRange> computeEquivalentCharRanges(State start) {
        CharRangeAccumulator acc = new CharRangeAccumulator();
        WorkSet todo = new WorkSet();
        todo.add(start);
        while (!todo.isEmpty()) {
            State state = (State)todo.remove();
            for (Transition transition : state.out()) {
                if (transition instanceof OrdinaryTransition) {
                    OrdinaryTransition ordinaryTransition = (OrdinaryTransition)transition;
                    acc.split(ordinaryTransition.getFrom(), ordinaryTransition.getTo());
                }
                todo.add(transition.getTarget());
            }
        }
        return acc.getRanges();
    }

    private void mergeTransitions() {
        WorkSet todo = new WorkSet();
        todo.add(this.start);
        while (!todo.isEmpty()) {
            State state = (State)todo.remove();
            TreeSet<Transition> transitions = new TreeSet<Transition>(new TransitionComparator());
            transitions.addAll(state.out());
            Transition last = null;
            for (Transition transition : transitions) {
                if (last == null) {
                    last = transition;
                    continue;
                }
                Transition joined = this.tryJoin(last, transition);
                if (joined == null) {
                    if (!transitions.contains(last)) {
                        last.connect();
                    }
                    last = transition;
                    continue;
                }
                if (joined == last) {
                    transition.remove();
                    continue;
                }
                if (joined == transition) {
                    if (transitions.contains(last)) {
                        last.remove();
                    }
                    last = joined;
                    continue;
                }
                if (transitions.contains(last)) {
                    last.remove();
                }
                transition.remove();
                last = joined;
            }
            if (last == null || transitions.contains(last)) continue;
            last.connect();
        }
        NFA.clean(this.start, null);
    }

    private Transition tryJoin(Transition t1, Transition t2) {
        if (t1.getTarget() != t2.getTarget() || t1.getOrigin() != t2.getOrigin()) {
            return null;
        }
        State origin = t1.getOrigin();
        State target = t1.getTarget();
        if (t1 instanceof EpsilonTransition && t2 instanceof EpsilonTransition) {
            return new EpsilonTransition(origin, target);
        }
        if (t1 instanceof OrdinaryTransition && t2 instanceof OrdinaryTransition) {
            OrdinaryTransition ot1 = (OrdinaryTransition)t1;
            OrdinaryTransition ot2 = (OrdinaryTransition)t2;
            int from1 = ot1.getFrom() & 0xFFFF;
            int to1 = ot1.getTo() & 0xFFFF;
            int from2 = ot2.getFrom() & 0xFFFF;
            int to2 = ot2.getTo() & 0xFFFF;
            if (from2 >= from1 && from2 <= to1 + 1 || from1 >= from2 && from1 <= to2 + 1) {
                char from = (char)Math.min(from1, from2);
                char to = (char)Math.max(to1, to2);
                if (from1 == from && to1 == to) {
                    return ot1;
                }
                if (from2 == from && to2 == to) {
                    return ot2;
                }
                return new CharsTransition(origin, from, to, target);
            }
        }
        return null;
    }

    private void eliminateTrivialEpsilons() {
        WorkSet todo = new WorkSet();
        todo.add(this.start);
        while (!todo.isEmpty()) {
            State state = (State)todo.remove();
            for (Transition transition : state.out()) {
                todo.add(transition.getTarget());
            }
            for (EpsilonTransition epsilon : this.transitiveEpsilons(state)) {
                State target;
                State origin = epsilon.getOrigin();
                if (origin == state) {
                    epsilon.remove();
                }
                if ((target = epsilon.getTarget()).isAccepting()) {
                    state.setAccepting();
                }
                if (!target.isSilent()) {
                    state.setSilent(false);
                }
                for (Transition transition : target.out()) {
                    if (!(transition instanceof OrdinaryTransition)) continue;
                    transition.asPrototype().withOrigin(state).withTarget(transition.getTarget()).connect();
                }
                for (Transition transition : target.out()) {
                    Action action;
                    if (!(transition instanceof EpsilonTransition) || (action = transition.getAction()) == null) continue;
                    transition.asPrototype().withOrigin(state).withTarget(transition.getTarget()).withAction(action).connect();
                }
            }
        }
        this.init(this.start);
    }

    private Set<EpsilonTransition> transitiveEpsilons(State state) {
        WorkSet todo = new WorkSet();
        for (Transition transition : state.out()) {
            if (!(transition instanceof EpsilonTransition)) continue;
            todo.add((Object)((EpsilonTransition)transition));
        }
        while (!todo.isEmpty()) {
            EpsilonTransition current = (EpsilonTransition)todo.remove();
            if (current.getAction() != null) {
                todo.remove((Object)current);
                continue;
            }
            State target = current.getTarget();
            for (Transition transition : target.out()) {
                if (!(transition instanceof EpsilonTransition)) continue;
                todo.add((Object)((EpsilonTransition)transition));
            }
        }
        return todo.getDone();
    }

    private void eliminateAllEpsilons() {
        EpsilonTransition epsilon;
        LinkedList<EpsilonTransition> epsilons = new LinkedList<EpsilonTransition>();
        WorkSet todo = new WorkSet();
        todo.add(this.start);
        while (!todo.isEmpty()) {
            State state = (State)todo.remove();
            for (Transition transition : state.out()) {
                todo.add(transition.getTarget());
                if (!(transition instanceof EpsilonTransition)) continue;
                epsilons.add((EpsilonTransition)transition);
            }
        }
        WorkSet propagateEpsilons = new WorkSet();
        propagateEpsilons.addAll(epsilons);
        while (!propagateEpsilons.isEmpty()) {
            epsilon = (EpsilonTransition)propagateEpsilons.remove();
            Set<EpsilonTransition> done = this.propagateStates(epsilon);
            propagateEpsilons.removeAll(done);
            propagateEpsilons.getDone().addAll(done);
        }
        while (!epsilons.isEmpty()) {
            epsilon = (EpsilonTransition)epsilons.remove();
            State origin = epsilon.getOrigin();
            State target = epsilon.getTarget();
            int in = origin.in().size();
            int out = target.out().size();
            if (origin == this.start) {
                this.eliminateForward(epsilon);
                continue;
            }
            if (in >= out) {
                this.eliminateForward(epsilon);
                continue;
            }
            this.eliminateBackward(epsilon);
        }
        this.init(this.start);
    }

    private Set<EpsilonTransition> propagateStates(EpsilonTransition epsilon) {
        boolean accepting = false;
        boolean silent = true;
        HashSet<EpsilonTransition> propagated = new HashSet<EpsilonTransition>();
        WorkSet eclosure = new WorkSet();
        eclosure.add((Object)epsilon.getOrigin());
        eclosure.add((Object)epsilon.getTarget());
        while (!eclosure.isEmpty()) {
            State next = (State)eclosure.remove();
            accepting |= next.isAccepting();
            silent &= next.isSilent();
            for (Transition transition : next.out()) {
                if (!(transition instanceof EpsilonTransition)) continue;
                propagated.add((EpsilonTransition)transition);
                eclosure.add((Object)transition.getTarget());
            }
            for (Transition transition : next.in()) {
                if (!(transition instanceof EpsilonTransition)) continue;
                propagated.add((EpsilonTransition)transition);
                eclosure.add((Object)transition.getOrigin());
            }
        }
        for (State state : eclosure.getDone()) {
            state.setAccepting(accepting);
            state.setSilent(silent);
        }
        return propagated;
    }

    private void eliminateForward(EpsilonTransition epsilon) {
        State origin = epsilon.getOrigin();
        WorkSet targets = new WorkSet();
        targets.add((Object)epsilon.getTarget());
        while (!targets.isEmpty()) {
            State next = (State)targets.remove();
            for (Transition transition : next.out()) {
                if (transition instanceof OrdinaryTransition) {
                    transition.asPrototype().withOrigin(origin).withTarget(transition.getTarget()).connect();
                    continue;
                }
                if (!(transition instanceof EpsilonTransition)) continue;
                targets.add((Object)transition.getTarget());
            }
        }
        epsilon.remove();
        if (origin.out().isEmpty() && !origin.isAccepting()) {
            origin.disconnect();
        }
        for (State target : targets.getDone()) {
            if (!target.in().isEmpty() || target == this.start) continue;
            target.disconnect();
        }
    }

    private void eliminateBackward(EpsilonTransition epsilon) {
        State target = epsilon.getTarget();
        WorkSet origins = new WorkSet();
        origins.add((Object)epsilon.getOrigin());
        while (!origins.isEmpty()) {
            State next = (State)origins.remove();
            for (Transition transition : next.in()) {
                if (transition instanceof OrdinaryTransition) {
                    transition.asPrototype().withOrigin(transition.getOrigin()).withTarget(target).connect();
                    continue;
                }
                if (!(transition instanceof EpsilonTransition)) continue;
                origins.add((Object)transition.getOrigin());
            }
        }
        epsilon.remove();
        if (target.in().isEmpty() && target != this.start) {
            target.disconnect();
        }
        for (State origin : origins.getDone()) {
            if (!origin.out().isEmpty()) continue;
            origin.disconnect();
        }
    }

    public NFA clone() {
        try {
            NFA nfa = (NFA)super.clone();
            StateClone stateClone = StateClone.cloneTree(this.start);
            nfa.init(stateClone.getStart());
            return nfa;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    private static class SplitPartition {
        public Set<State> max;
        public Set<State> min;

        public SplitPartition(Set<State> intersection, Set<State> remainder) {
            this.max = intersection.size() > remainder.size() ? intersection : remainder;
            this.min = intersection.size() <= remainder.size() ? intersection : remainder;
        }
    }
}

