/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.patternsearchalgorithms.automaton.bytes;

import java.nio.charset.Charset;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.EpsilonTransition;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.NFA;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.NFAComponent;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.NFAComponentFactory;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.State;

public class MinimalNFAComponentFactory
implements NFAComponentFactory {
    private Charset charset;

    public MinimalNFAComponentFactory(Charset charset) {
        this.charset = charset;
    }

    @Override
    public NFAComponent create(State start, State end) {
        end.setAccepting();
        NFA nfa = new NFA(start, this.charset);
        nfa.determinize();
        return new NFAComponent(nfa.getStart(), this.getEnd(nfa));
    }

    private State getEnd(NFA nfa) {
        State[] accepting = nfa.accepting();
        switch (accepting.length) {
            case 0: {
                return null;
            }
            case 1: {
                State existingend = accepting[0];
                existingend.setAccepting(false);
                return existingend;
            }
        }
        State joinend = new State();
        for (State accept : accepting) {
            accept.setAccepting(false);
            new EpsilonTransition(accept, joinend).connect();
        }
        return joinend;
    }
}

