/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.patternsearchalgorithms.pattern.chars;

import net.amygdalum.patternsearchalgorithms.automaton.chars.DFA;
import net.amygdalum.patternsearchalgorithms.automaton.chars.Groups;
import net.amygdalum.patternsearchalgorithms.automaton.chars.NFA;
import net.amygdalum.patternsearchalgorithms.pattern.Matcher;
import net.amygdalum.util.io.CharProvider;

public class SimpleLongestOverlappingMatcher
implements Matcher {
    private DFA matcher;
    private NFA grouper;
    private CharProvider input;
    private final long start;
    private Groups groups;

    public SimpleLongestOverlappingMatcher(DFA matcher, NFA grouper, CharProvider input) {
        this.matcher = matcher;
        this.grouper = grouper;
        this.input = input;
        this.start = input.current();
        this.groups = new Groups();
    }

    @Override
    public boolean matches() {
        int state = this.matcher.start;
        while (!this.input.finished() && state >= 0) {
            char c = this.input.next();
            state = this.matcher.next(state, c);
        }
        if (this.matcher.accept(state)) {
            this.groups.update(this.start, this.input.current());
            this.input.move(this.start);
            return true;
        }
        this.input.move(this.start);
        return false;
    }

    @Override
    public boolean prefixes() {
        int state = this.matcher.start;
        if (this.matcher.accept(state)) {
            this.groups.update(this.start, this.input.current());
        }
        while (!this.input.finished() && state >= 0) {
            char c = this.input.next();
            if ((state = this.matcher.next(state, c)) == -1) {
                this.input.move(this.start);
                return this.groups.valid();
            }
            if (!this.matcher.accept(state)) continue;
            this.groups.update(this.start, this.input.current());
        }
        if (this.matcher.accept(state)) {
            this.groups.update(this.start, this.input.current());
            this.input.move(this.start);
            return true;
        }
        this.input.move(this.start);
        return this.groups.valid();
    }

    @Override
    public boolean find() {
        int state = this.matcher.start;
        if (this.matcher.accept(state)) {
            this.groups.update(this.start, this.input.current());
        } else {
            this.groups.reset();
        }
        long localstart = this.input.current();
        while (!this.input.finished() && state >= 0) {
            char c = this.input.next();
            if ((state = this.matcher.next(state, c)) == -1) {
                if (this.groups.invalid()) {
                    this.input.move(++localstart);
                    state = this.matcher.start;
                    continue;
                }
                this.input.move(localstart + 1L);
                return true;
            }
            if (!this.matcher.accept(state)) continue;
            this.groups.update(localstart, this.input.current());
        }
        if (this.matcher.accept(state)) {
            this.groups.update(localstart, this.input.current());
            return true;
        }
        return false;
    }

    @Override
    public long start() {
        return this.groups.getStart();
    }

    @Override
    public long start(int no) {
        if (!this.groups.isComplete()) {
            this.groups.process(this.input, this.grouper);
        }
        return this.groups.getStart(no);
    }

    @Override
    public long end() {
        return this.groups.getEnd();
    }

    @Override
    public long end(int no) {
        if (!this.groups.isComplete()) {
            this.groups.process(this.input, this.grouper);
        }
        return this.groups.getEnd(no);
    }

    @Override
    public String group() {
        long start = this.groups.getStart();
        long end = this.groups.getEnd();
        if (start != -1L && end != -1L && start <= end) {
            return this.input.slice(start, end);
        }
        return null;
    }

    @Override
    public String group(int no) {
        if (!this.groups.isComplete()) {
            this.groups.process(this.input, this.grouper);
        }
        long start = this.groups.getStart(no);
        long end = this.groups.getEnd(no);
        if (start != -1L && end != -1L && start <= end) {
            return this.input.slice(start, end);
        }
        return null;
    }
}

