/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.patternsearchalgorithms.pattern.bytes;

import java.nio.charset.Charset;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.DFA;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.NFA;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.NFABuilder;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.NFAComponent;
import net.amygdalum.patternsearchalgorithms.pattern.Matcher;
import net.amygdalum.patternsearchalgorithms.pattern.SearchMode;
import net.amygdalum.patternsearchalgorithms.pattern.bytes.MatcherFactory;
import net.amygdalum.patternsearchalgorithms.pattern.bytes.SimpleAllNonOverlappingMatcher;
import net.amygdalum.patternsearchalgorithms.pattern.bytes.SimpleAllOverlappingMatcher;
import net.amygdalum.patternsearchalgorithms.pattern.bytes.SimpleLongestNonOverlappingMatcher;
import net.amygdalum.patternsearchalgorithms.pattern.bytes.SimpleLongestOverlappingMatcher;
import net.amygdalum.regexparser.RegexNode;
import net.amygdalum.regexparser.RegexNodeVisitor;
import net.amygdalum.util.io.ByteProvider;

public class SimpleMatcherFactory
implements MatcherFactory {
    private SearchMode mode;
    private Charset charset;
    private DFA matcher;
    private NFA grouper;

    public SimpleMatcherFactory(SearchMode mode, Charset charset) {
        this.mode = mode;
        this.charset = charset;
    }

    public static SimpleMatcherFactory compile(RegexNode node, Charset charset, SearchMode mode) {
        return new SimpleMatcherFactory(mode, charset).compile(node);
    }

    private SimpleMatcherFactory compile(RegexNode node) {
        this.matcher = this.matcherFrom(node);
        this.grouper = this.grouperFrom(node);
        return this;
    }

    private DFA matcherFrom(RegexNode node) {
        NFABuilder builder = new NFABuilder(this.charset);
        return DFA.from(builder.build(node));
    }

    private NFA grouperFrom(RegexNode node) {
        NFABuilder builder = new NFABuilder(this.charset);
        NFAComponent base = builder.matchGroup((NFAComponent)node.accept((RegexNodeVisitor)builder), 0);
        NFA grouper = builder.build(base);
        grouper.prune();
        return grouper;
    }

    @Override
    public Matcher newMatcher(ByteProvider input) {
        if (this.mode.findLongest()) {
            if (this.mode.findOverlapping()) {
                return new SimpleLongestOverlappingMatcher(this.matcher, this.grouper, input);
            }
            return new SimpleLongestNonOverlappingMatcher(this.matcher, this.grouper, input);
        }
        if (this.mode.findOverlapping()) {
            return new SimpleAllOverlappingMatcher(this.matcher, this.grouper, input);
        }
        return new SimpleAllNonOverlappingMatcher(this.matcher, this.grouper, input);
    }
}

