/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.patternsearchalgorithms.pattern.bytes;

import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.Queue;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.DFA;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.Groups;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.NFA;
import net.amygdalum.patternsearchalgorithms.pattern.Matcher;
import net.amygdalum.util.io.ByteProvider;
import net.amygdalum.util.io.ReverseByteProvider;

public class SearchAllNonOverlappingMatcher
implements Matcher {
    private DFA finder;
    private DFA backmatcher;
    private NFA grouper;
    private ByteProvider input;
    private final long start;
    private Groups groups;
    private Queue<Groups> nextgroups;

    public SearchAllNonOverlappingMatcher(DFA finder, DFA backmatcher, NFA grouper, ByteProvider input) {
        this.finder = finder;
        this.backmatcher = backmatcher;
        this.grouper = grouper;
        this.input = input;
        this.start = input.current();
        this.groups = new Groups();
        this.nextgroups = new PriorityQueue<Groups>();
    }

    @Override
    public boolean matches() {
        this.input.finish();
        long end = this.input.current();
        boolean match = this.verifyPrefix(this.start);
        this.input.move(this.start);
        if (match) {
            this.groups.update(this.start, end);
            return true;
        }
        return false;
    }

    @Override
    public boolean prefixes() {
        int state = this.finder.start;
        if (this.finder.accept(state)) {
            this.groups.update(this.start, this.start);
            this.input.move(this.start);
            return true;
        }
        while (!this.input.finished() && state >= 0 && !this.finder.silent(state)) {
            byte b = this.input.next();
            if (!this.finder.accept(state = this.finder.next(state, b))) continue;
            long end = this.input.current();
            boolean match = this.verifyPrefix(this.start);
            this.input.move(end);
            if (!match) continue;
            this.groups.update(this.start, end);
            this.input.move(this.start);
            return true;
        }
        this.input.move(this.start);
        return false;
    }

    private boolean verifyPrefix(long pos) {
        ReverseByteProvider reverse = new ReverseByteProvider(this.input);
        int state = this.backmatcher.start;
        while (reverse.current() > pos && state >= 0) {
            byte b = reverse.next();
            state = this.backmatcher.next(state, b);
        }
        return this.backmatcher.accept(state);
    }

    @Override
    public boolean find() {
        if (!this.nextgroups.isEmpty()) {
            Groups first = this.nextGroup();
            this.groups.update(first.getStart(), first.getEnd());
            return true;
        }
        int state = this.finder.start;
        if (this.finder.accept(state)) {
            this.nextgroups.add(new Groups(this.start, this.input.current()));
        } else {
            this.groups.reset();
        }
        while (!this.input.finished() && state >= 0 && !this.finder.silent(state)) {
            byte b = this.input.next();
            if (!this.finder.accept(state = this.finder.next(state, b))) continue;
            long end = this.input.current();
            this.verifyMatches();
            this.input.move(end);
        }
        if (this.finder.accept(state)) {
            long end = this.input.current();
            this.verifyMatches();
            this.input.move(end);
        }
        if (this.nextgroups.isEmpty()) {
            return false;
        }
        Groups first = this.nextGroup();
        this.groups.update(first.getStart(), first.getEnd());
        return true;
    }

    private void verifyMatches() {
        long end = this.input.current();
        ReverseByteProvider reverse = new ReverseByteProvider(this.input);
        int state = this.backmatcher.start;
        if (this.backmatcher.accept(state)) {
            this.nextgroups.add(new Groups(end, end));
        }
        while (!reverse.finished() && state >= 0) {
            byte b = reverse.next();
            if (!this.backmatcher.accept(state = this.backmatcher.next(state, b))) continue;
            long start = this.input.current();
            this.nextgroups.add(new Groups(start, end));
        }
        if (this.backmatcher.accept(state)) {
            long start = this.input.current();
            this.nextgroups.add(new Groups(start, end));
        }
    }

    private Groups nextGroup() {
        Groups current;
        Groups groups = this.nextgroups.remove();
        Iterator groupsIterator = this.nextgroups.iterator();
        while (groupsIterator.hasNext() && (current = (Groups)groupsIterator.next()).overlaps(groups) && groups.getEnd() != current.getStart()) {
            groupsIterator.remove();
        }
        return groups;
    }

    @Override
    public long start() {
        return this.groups.getStart();
    }

    @Override
    public long start(int no) {
        if (!this.groups.isComplete()) {
            this.groups.process(this.input, this.grouper);
        }
        return this.groups.getStart(no);
    }

    @Override
    public long end() {
        return this.groups.getEnd();
    }

    @Override
    public long end(int no) {
        if (!this.groups.isComplete()) {
            this.groups.process(this.input, this.grouper);
        }
        return this.groups.getEnd(no);
    }

    @Override
    public String group() {
        long start = this.groups.getStart();
        long end = this.groups.getEnd();
        if (start != -1L && end != -1L && start <= end) {
            return this.input.slice(start, end).getString();
        }
        return null;
    }

    @Override
    public String group(int no) {
        if (!this.groups.isComplete()) {
            this.groups.process(this.input, this.grouper);
        }
        long start = this.groups.getStart(no);
        long end = this.groups.getEnd(no);
        if (start != -1L && end != -1L && start <= end) {
            return this.input.slice(start, end).getString();
        }
        return null;
    }
}

