/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.patternsearchalgorithms.pattern;

import net.amygdalum.patternsearchalgorithms.pattern.BytePattern;
import net.amygdalum.patternsearchalgorithms.pattern.CharPattern;
import net.amygdalum.patternsearchalgorithms.pattern.CharsetOption;
import net.amygdalum.patternsearchalgorithms.pattern.Matcher;
import net.amygdalum.patternsearchalgorithms.pattern.OptimizationTarget;
import net.amygdalum.patternsearchalgorithms.pattern.PatternOption;
import net.amygdalum.patternsearchalgorithms.pattern.RegexOption;
import net.amygdalum.patternsearchalgorithms.pattern.SearchMode;
import net.amygdalum.util.io.ByteProvider;
import net.amygdalum.util.io.CharProvider;

public abstract class Pattern {
    public static Pattern compile(String pattern, PatternOption ... options) {
        CharsetOption charset = CharsetOption.firstOf(options);
        RegexOption[] regexOptions = RegexOption.allOf(options);
        OptimizationTarget optimizations = OptimizationTarget.bestOf(options);
        SearchMode mode = SearchMode.firstOf(options);
        if (charset == null) {
            return CharPattern.compile(pattern, regexOptions, optimizations, mode);
        }
        return BytePattern.compile(pattern, charset, regexOptions, optimizations, mode);
    }

    public abstract String pattern();

    public abstract Matcher matcher(String var1);

    public abstract Matcher matcher(CharProvider var1);

    public abstract Matcher matcher(byte[] var1);

    public abstract Matcher matcher(ByteProvider var1);
}

