/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.patternsearchalgorithms.pattern;

import java.nio.charset.StandardCharsets;
import net.amygdalum.patternsearchalgorithms.pattern.Matcher;
import net.amygdalum.patternsearchalgorithms.pattern.OptimizationTarget;
import net.amygdalum.patternsearchalgorithms.pattern.Pattern;
import net.amygdalum.patternsearchalgorithms.pattern.RegexOption;
import net.amygdalum.patternsearchalgorithms.pattern.SearchMode;
import net.amygdalum.patternsearchalgorithms.pattern.chars.MatcherFactory;
import net.amygdalum.patternsearchalgorithms.pattern.chars.SearchMatcherFactory;
import net.amygdalum.patternsearchalgorithms.pattern.chars.SimpleMatcherFactory;
import net.amygdalum.regexparser.RegexNode;
import net.amygdalum.regexparser.RegexParser;
import net.amygdalum.regexparser.RegexParserOption;
import net.amygdalum.util.io.ByteProvider;
import net.amygdalum.util.io.CharProvider;
import net.amygdalum.util.io.StringCharProvider;

class CharPattern
extends Pattern {
    private String pattern;
    private MatcherFactory factory;

    CharPattern(String pattern, MatcherFactory factory) {
        this.pattern = pattern;
        this.factory = factory;
    }

    @Override
    public String pattern() {
        return this.pattern;
    }

    @Override
    public Matcher matcher(String input) {
        StringCharProvider chars = new StringCharProvider(input, 0);
        return this.factory.newMatcher((CharProvider)chars);
    }

    @Override
    public Matcher matcher(CharProvider input) {
        return this.factory.newMatcher(input);
    }

    @Override
    public Matcher matcher(byte[] input) {
        StringCharProvider chars = new StringCharProvider(new String(input, StandardCharsets.UTF_8), 0);
        return this.factory.newMatcher((CharProvider)chars);
    }

    @Override
    public Matcher matcher(ByteProvider input) {
        throw new UnsupportedOperationException();
    }

    static Pattern compile(String pattern, RegexOption[] regexOptions, OptimizationTarget optimizations, SearchMode mode) {
        RegexNode node = CharPattern.buildNFAFrom(pattern, regexOptions);
        MatcherFactory factory = CharPattern.buildFactory(node, optimizations, mode);
        return new CharPattern(pattern, factory);
    }

    private static MatcherFactory buildFactory(RegexNode node, OptimizationTarget optimizationTarget, SearchMode mode) {
        switch (optimizationTarget) {
            case SEARCH: {
                return SearchMatcherFactory.compile(node, mode);
            }
        }
        return SimpleMatcherFactory.compile(node, mode);
    }

    public static RegexNode buildNFAFrom(String pattern, RegexOption[] regexOptions) {
        RegexParserOption[] parserOptions = RegexOption.toRegexParserOptions(regexOptions);
        RegexParser parser = new RegexParser(pattern, parserOptions);
        return parser.parse();
    }
}

