/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.patternsearchalgorithms.pattern;

import java.nio.charset.Charset;
import net.amygdalum.patternsearchalgorithms.pattern.CharsetOption;
import net.amygdalum.patternsearchalgorithms.pattern.Matcher;
import net.amygdalum.patternsearchalgorithms.pattern.OptimizationTarget;
import net.amygdalum.patternsearchalgorithms.pattern.Pattern;
import net.amygdalum.patternsearchalgorithms.pattern.RegexOption;
import net.amygdalum.patternsearchalgorithms.pattern.SearchMode;
import net.amygdalum.patternsearchalgorithms.pattern.bytes.MatcherFactory;
import net.amygdalum.patternsearchalgorithms.pattern.bytes.SearchMatcherFactory;
import net.amygdalum.patternsearchalgorithms.pattern.bytes.SimpleMatcherFactory;
import net.amygdalum.regexparser.RegexNode;
import net.amygdalum.regexparser.RegexParser;
import net.amygdalum.regexparser.RegexParserOption;
import net.amygdalum.util.io.ByteProvider;
import net.amygdalum.util.io.CharProvider;
import net.amygdalum.util.io.StringByteProvider;

class BytePattern
extends Pattern {
    private String pattern;
    private MatcherFactory factory;
    private Charset charset;

    BytePattern(String pattern, MatcherFactory factory, Charset charset) {
        this.pattern = pattern;
        this.factory = factory;
        this.charset = charset;
    }

    @Override
    public String pattern() {
        return this.pattern;
    }

    @Override
    public Matcher matcher(String input) {
        StringByteProvider bytes = new StringByteProvider(input, 0, this.charset);
        return this.factory.newMatcher((ByteProvider)bytes);
    }

    @Override
    public Matcher matcher(CharProvider input) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Matcher matcher(byte[] input) {
        return this.factory.newMatcher((ByteProvider)new StringByteProvider(input, 0, this.charset));
    }

    @Override
    public Matcher matcher(ByteProvider input) {
        return this.factory.newMatcher(input);
    }

    static Pattern compile(String pattern, CharsetOption charset, RegexOption[] regexOptions, OptimizationTarget optimizations, SearchMode mode) {
        RegexNode node = BytePattern.buildNFAFrom(pattern, regexOptions);
        MatcherFactory factory = BytePattern.buildFactory(node, charset, optimizations, mode);
        return new BytePattern(pattern, factory, charset.getCharset());
    }

    private static MatcherFactory buildFactory(RegexNode node, CharsetOption charset, OptimizationTarget optimizationTarget, SearchMode mode) {
        switch (optimizationTarget) {
            case SEARCH: {
                return SearchMatcherFactory.compile(node, charset.getCharset(), mode);
            }
        }
        return SimpleMatcherFactory.compile(node, charset.getCharset(), mode);
    }

    public static RegexNode buildNFAFrom(String pattern, RegexOption[] regexOptions) {
        RegexParserOption[] parserOptions = RegexOption.toRegexParserOptions(regexOptions);
        RegexParser parser = new RegexParser(pattern, parserOptions);
        return parser.parse();
    }
}

