/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.patternsearchalgorithms.automaton.bytes;

import java.util.Comparator;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.EpsilonTransition;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.OrdinaryTransition;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.State;
import net.amygdalum.patternsearchalgorithms.automaton.bytes.Transition;

public class TransitionComparator
implements Comparator<Transition> {
    @Override
    public int compare(Transition t1, Transition t2) {
        int compare = this.compareTargets(t1.getTarget(), t2.getTarget());
        if (compare != 0) {
            return compare;
        }
        if (t1 instanceof EpsilonTransition && t2 instanceof EpsilonTransition) {
            return 0;
        }
        if (t1 instanceof OrdinaryTransition && t2 instanceof EpsilonTransition) {
            return 1;
        }
        if (t1 instanceof EpsilonTransition && t2 instanceof OrdinaryTransition) {
            return -1;
        }
        if (t1 instanceof OrdinaryTransition && t2 instanceof OrdinaryTransition) {
            OrdinaryTransition ot1 = (OrdinaryTransition)t1;
            OrdinaryTransition ot2 = (OrdinaryTransition)t2;
            if (ot1.getFrom() < ot2.getFrom()) {
                return -1;
            }
            if (ot1.getFrom() > ot2.getFrom()) {
                return 1;
            }
            if (ot1.getTo() < ot2.getTo()) {
                return -1;
            }
            if (ot1.getTo() > ot2.getTo()) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    private int compareTargets(State t1, State t2) {
        return Integer.compare(t1.getId(), t2.getId());
    }
}

